/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.reader;

import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclarationList;
import com.phloc.css.handler.CSSHandler;
import com.phloc.css.handler.DoNothingCSSParseExceptionHandler;
import com.phloc.css.handler.ICSSParseExceptionHandler;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.CharStream;
import com.phloc.css.parser.JavaCharStream;
import com.phloc.css.parser.ParseException;
import com.phloc.css.parser.ParserCSS21;
import com.phloc.css.parser.ParserCSS21TokenManager;
import com.phloc.css.parser.ParserCSS30;
import com.phloc.css.parser.ParserCSS30TokenManager;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSReaderDeclarationList {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReaderDeclarationList.class);

    private CSSReaderDeclarationList() {
    }

    @Nullable
    private static CSSNode _readStyleDeclaration(@Nonnull CharStream aStream, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        switch (eVersion) {
            case CSS21: {
                ParserCSS21TokenManager aTokenHdl = new ParserCSS21TokenManager(aStream);
                ParserCSS21 aParser = new ParserCSS21(aTokenHdl);
                try {
                    return aParser.styleDeclaration();
                }
                catch (ParseException ex) {
                    if (aCustomExceptionHandler != null) {
                        aCustomExceptionHandler.onException(ex);
                    } else {
                        s_aLogger.error("Failed to parse CSS 2.1 style declaration: " + ex.getMessage());
                    }
                    return null;
                }
            }
            case CSS30: {
                ParserCSS30TokenManager aTokenHdl = new ParserCSS30TokenManager(aStream);
                ParserCSS30 aParser = new ParserCSS30(aTokenHdl);
                try {
                    return aParser.styleDeclaration();
                }
                catch (ParseException ex) {
                    if (aCustomExceptionHandler != null) {
                        aCustomExceptionHandler.onException(ex);
                    } else {
                        s_aLogger.error("Failed to parse CSS 3.0 style declaration: " + ex.getMessage());
                    }
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eVersion));
    }

    public static boolean isValidCSS(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(aFile), sCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(aFile), aCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource aRes, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        Charset aCharset = CharsetManager.getCharsetFromName((String)sCharset);
        if (aCharset == null) {
            throw new IllegalArgumentException("Illegal charset '" + sCharset + "'");
        }
        return CSSReaderDeclarationList.isValidCSS(aRes, aCharset, eVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource aRes, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        if (aRes == null) {
            throw new NullPointerException("resources");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        if (eVersion == null) {
            throw new NullPointerException("version");
        }
        Reader aReader = aRes.getReader(aCharset);
        if (aReader == null) {
            s_aLogger.warn("Failed to open CSS reader " + aRes);
            return false;
        }
        return CSSReaderDeclarationList.isValidCSS(aReader, eVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream aIS, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        if (sCharset == null) {
            throw new NullPointerException("charset");
        }
        return CSSReaderDeclarationList.isValidCSS(StreamUtils.createReader((InputStream)aIS, (String)sCharset), eVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream aIS, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        return CSSReaderDeclarationList.isValidCSS(StreamUtils.createReader((InputStream)aIS, (Charset)aCharset), eVersion);
    }

    public static boolean isValidCSS(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        if (sCSS == null) {
            throw new NullPointerException("reader");
        }
        return CSSReaderDeclarationList.isValidCSS((Reader)new NonBlockingStringReader(sCSS), eVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion) {
        if (aReader == null) {
            throw new NullPointerException("reader");
        }
        if (eVersion == null) {
            throw new NullPointerException("version");
        }
        try {
            JavaCharStream aCharStream = new JavaCharStream(aReader);
            CSSNode aNode = CSSReaderDeclarationList._readStyleDeclaration(aCharStream, eVersion, new DoNothingCSSParseExceptionHandler());
            boolean bl = aNode != null;
            return bl;
        }
        finally {
            StreamUtils.close((Closeable)aReader);
        }
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(sCSS), eVersion, null);
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String sCSS, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(sCSS), eVersion, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromFile(aFile, sCharset, eVersion, null);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromFile(aFile, aCharset, eVersion, null);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(aFile).getReader(sCharset), eVersion, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(aFile).getReader(aCharset), eVersion, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromStream(aISP, sCharset, eVersion, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromStream(aISP, aCharset, eVersion, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull String sCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        if (aISP == null) {
            throw new NullPointerException("inputStreamProvider");
        }
        InputStream aIS = aISP.getInputStream();
        if (aIS == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromReader(StreamUtils.createReader((InputStream)aIS, (String)sCharset), eVersion, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IInputStreamProvider aISP, @Nonnull Charset aCharset, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        if (aISP == null) {
            throw new NullPointerException("inputStreamProvider");
        }
        InputStream aIS = aISP.getInputStream();
        if (aIS == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromReader(StreamUtils.createReader((InputStream)aIS, (Charset)aCharset), eVersion, aCustomExceptionHandler);
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion) {
        return CSSReaderDeclarationList.readFromReader(aReader, eVersion, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader aReader, @Nonnull ECSSVersion eVersion, @Nullable ICSSParseExceptionHandler aCustomExceptionHandler) {
        if (aReader == null) {
            throw new NullPointerException("reader");
        }
        if (eVersion == null) {
            throw new NullPointerException("version");
        }
        try {
            JavaCharStream aCharStream = new JavaCharStream(aReader);
            CSSNode aNode = CSSReaderDeclarationList._readStyleDeclaration(aCharStream, eVersion, aCustomExceptionHandler);
            if (aNode == null) {
                CSSDeclarationList cSSDeclarationList = null;
                return cSSDeclarationList;
            }
            CSSDeclarationList cSSDeclarationList = CSSHandler.readDeclarationListFromNode(eVersion, aNode);
            return cSSDeclarationList;
        }
        finally {
            StreamUtils.close((Closeable)aReader);
        }
    }
}

