/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl.visit;

import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesBlock;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.decl.IHasCSSDeclarations;
import com.phloc.css.decl.visit.CSSVisitorForUrl;
import com.phloc.css.decl.visit.ICSSUrlVisitor;
import com.phloc.css.decl.visit.ICSSVisitor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSVisitor {
    private CSSVisitor() {
    }

    public static void visitAllDeclarations(@Nonnull IHasCSSDeclarations aHasDeclarations, @Nonnull ICSSVisitor aVisitor) {
        for (CSSDeclaration aDeclaration : aHasDeclarations.getAllDeclarations()) {
            aVisitor.onDeclaration(aDeclaration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitStyleRule(@Nonnull CSSStyleRule aStyleRule, @Nonnull ICSSVisitor aVisitor) {
        aVisitor.onBeginStyleRule(aStyleRule);
        try {
            for (CSSSelector aSelector : aStyleRule.getAllSelectors()) {
                aVisitor.onStyleRuleSelector(aSelector);
            }
            CSSVisitor.visitAllDeclarations(aStyleRule, aVisitor);
        }
        finally {
            aVisitor.onEndStyleRule(aStyleRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitPageRule(@Nonnull CSSPageRule aPageRule, @Nonnull ICSSVisitor aVisitor) {
        aVisitor.onBeginPageRule(aPageRule);
        try {
            CSSVisitor.visitAllDeclarations(aPageRule, aVisitor);
        }
        finally {
            aVisitor.onEndPageRule(aPageRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitFontFaceRule(@Nonnull CSSFontFaceRule aFontFaceRule, @Nonnull ICSSVisitor aVisitor) {
        aVisitor.onBeginFontFaceRule(aFontFaceRule);
        try {
            CSSVisitor.visitAllDeclarations(aFontFaceRule, aVisitor);
        }
        finally {
            aVisitor.onEndFontFaceRule(aFontFaceRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitMediaRule(@Nonnull CSSMediaRule aMediaRule, @Nonnull ICSSVisitor aVisitor) {
        aVisitor.onBeginMediaRule(aMediaRule);
        try {
            for (ICSSTopLevelRule aRule : aMediaRule.getAllRules()) {
                CSSVisitor.visitTopLevelRule(aRule, aVisitor);
            }
        }
        finally {
            aVisitor.onEndMediaRule(aMediaRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitKeyframesRule(@Nonnull CSSKeyframesRule aKeyframesRule, @Nonnull ICSSVisitor aVisitor) {
        aVisitor.onBeginKeyframesRule(aKeyframesRule);
        try {
            for (CSSKeyframesBlock aBlock : aKeyframesRule.getAllBlocks()) {
                aVisitor.onBeginKeyframesBlock(aBlock);
                try {
                    CSSVisitor.visitAllDeclarations(aBlock, aVisitor);
                }
                finally {
                    aVisitor.onEndKeyframesBlock(aBlock);
                }
            }
        }
        finally {
            aVisitor.onEndKeyframesRule(aKeyframesRule);
        }
    }

    public static void visitTopLevelRule(@Nonnull ICSSTopLevelRule aTopLevelRule, @Nonnull ICSSVisitor aVisitor) {
        if (aTopLevelRule instanceof CSSStyleRule) {
            CSSVisitor.visitStyleRule((CSSStyleRule)aTopLevelRule, aVisitor);
        } else if (aTopLevelRule instanceof CSSPageRule) {
            CSSVisitor.visitPageRule((CSSPageRule)aTopLevelRule, aVisitor);
        } else if (aTopLevelRule instanceof CSSFontFaceRule) {
            CSSVisitor.visitFontFaceRule((CSSFontFaceRule)aTopLevelRule, aVisitor);
        } else if (aTopLevelRule instanceof CSSMediaRule) {
            CSSVisitor.visitMediaRule((CSSMediaRule)aTopLevelRule, aVisitor);
        } else if (aTopLevelRule instanceof CSSKeyframesRule) {
            CSSVisitor.visitKeyframesRule((CSSKeyframesRule)aTopLevelRule, aVisitor);
        } else {
            throw new IllegalStateException("Top level rule " + aTopLevelRule + " is unsupported!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitCSS(@Nonnull CascadingStyleSheet aCSS, @Nonnull ICSSVisitor aVisitor) {
        if (aCSS == null) {
            throw new NullPointerException("CSS");
        }
        if (aVisitor == null) {
            throw new NullPointerException("visitor");
        }
        aVisitor.begin();
        try {
            for (CSSImportRule aImportRule : aCSS.getAllImportRules()) {
                aVisitor.onImport(aImportRule);
            }
            for (ICSSTopLevelRule aTopLevelRule : aCSS.getAllRules()) {
                CSSVisitor.visitTopLevelRule(aTopLevelRule, aVisitor);
            }
        }
        finally {
            aVisitor.end();
        }
    }

    public static void visitCSSUrl(@Nonnull CascadingStyleSheet aCSS, @Nonnull ICSSUrlVisitor aVisitor) {
        CSSVisitor.visitCSS(aCSS, new CSSVisitorForUrl(aVisitor));
    }

    public static void visitAllDeclarationUrls(@Nonnull IHasCSSDeclarations aCSS, @Nonnull ICSSUrlVisitor aVisitor) {
        CSSVisitor.visitAllDeclarations(aCSS, new CSSVisitorForUrl(aVisitor));
    }
}

