/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.name.IHasName;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSAttributeOperator implements ICSSVersionAware,
ICSSWriteable,
IHasName
{
    EQUALS("="),
    INCLUDES("~="),
    DASHMATCH("|="),
    BEGINMATCH("^=", ECSSVersion.CSS30),
    ENDMATCH("$=", ECSSVersion.CSS30),
    CONTAINSMATCH("*=");

    private final String m_sName;
    private final ECSSVersion m_eVersion;

    private ECSSAttributeOperator(String sName) {
        this(sName, ECSSVersion.CSS21);
    }

    private ECSSAttributeOperator(String sName, ECSSVersion eVersion) {
        this.m_sName = sName;
        this.m_eVersion = eVersion;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return this.m_eVersion;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        return this.m_sName;
    }

    @Nullable
    public static ECSSAttributeOperator getFromNameOrNull(@Nullable String sName) {
        return (ECSSAttributeOperator)EnumHelper.getFromNameOrNull(ECSSAttributeOperator.class, (String)sName);
    }
}

