/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.IHasCSSDeclarations;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclarationList
implements IHasCSSDeclarations {
    private final List<CSSDeclaration> m_aDeclarations = new ArrayList<CSSDeclaration>();

    @Override
    public final void addDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        if (aDeclaration == null) {
            throw new NullPointerException("declaration");
        }
        this.m_aDeclarations.add(aDeclaration);
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        return EChange.valueOf((boolean)this.m_aDeclarations.remove(aDeclaration));
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnegative int nDeclarationIndex) {
        if (nDeclarationIndex < 0 || nDeclarationIndex >= this.m_aDeclarations.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aDeclarations.remove(nDeclarationIndex) != null ? 1 : 0) != 0);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<CSSDeclaration> getAllDeclarations() {
        return ContainerHelper.newList(this.m_aDeclarations);
    }

    @Override
    @Nullable
    public final CSSDeclaration getDeclarationAtIndex(@Nonnegative int nIndex) {
        return (CSSDeclaration)ContainerHelper.getSafe(this.m_aDeclarations, (int)nIndex);
    }

    @Override
    @Nonnegative
    public final int getDeclarationCount() {
        return this.m_aDeclarations.size();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        int nDeclCount = this.m_aDeclarations.size();
        if (nDeclCount == 0) {
            return "";
        }
        if (nDeclCount == 1) {
            return ((CSSDeclaration)ContainerHelper.getFirstElement(this.m_aDeclarations)).getAsCSSString(aSettings, nIndentLevel);
        }
        StringBuilder aSB = new StringBuilder();
        for (CSSDeclaration aDeclaration : this.m_aDeclarations) {
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel + 1));
            }
            aSB.append(aDeclaration.getAsCSSString(aSettings, nIndentLevel + 1));
            if (bOptimizedOutput) continue;
            aSB.append('\n');
        }
        return aSB.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSDeclarationList)) {
            return false;
        }
        CSSDeclarationList rhs = (CSSDeclarationList)o;
        return ((Object)this.m_aDeclarations).equals(rhs.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declarations", this.m_aDeclarations).toString();
    }
}

