/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.CGlobal;
import com.phloc.commons.exceptions.InitializationException;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.xml.transform.DefaultTransformURIResolver;
import com.phloc.commons.xml.transform.LoggingTransformErrorListener;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class XMLTransformerFactory {
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLTransformerFactory.class);
    private static final TransformerFactory s_aFactory = XMLTransformerFactory.createTransformerFactory(new LoggingTransformErrorListener(CGlobal.DEFAULT_LOCALE), new DefaultTransformURIResolver());
    private static final XMLTransformerFactory s_aInstance = new XMLTransformerFactory();

    private XMLTransformerFactory() {
    }

    @Nonnull
    public static TransformerFactory createTransformerFactory(@Nullable ErrorListener aErrorListener, @Nullable URIResolver aURIResolver) {
        try {
            TransformerFactory aFactory = TransformerFactory.newInstance();
            if (aErrorListener != null) {
                aFactory.setErrorListener(aErrorListener);
            }
            if (aURIResolver != null) {
                aFactory.setURIResolver(aURIResolver);
            }
            return aFactory;
        }
        catch (TransformerFactoryConfigurationError ex) {
            throw new InitializationException("Failed to init XML TransformerFactory", ex);
        }
    }

    @Nonnull
    public static TransformerFactory getDefaultTransformerFactory() {
        return s_aFactory;
    }

    @Nullable
    public static Transformer newTransformer() {
        try {
            return s_aFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            s_aLogger.error("Failed to create transformer", (Throwable)ex);
            return null;
        }
    }

    @Nullable
    public static Transformer newTransformer(@Nonnull IReadableResource aResource) {
        if (aResource == null) {
            throw new NullPointerException("resource");
        }
        return XMLTransformerFactory.newTransformer(TransformSourceFactory.create(aResource));
    }

    @Nullable
    public static Transformer newTransformer(@Nonnull Source aSource) {
        if (aSource == null) {
            throw new NullPointerException("source");
        }
        try {
            return s_aFactory.newTransformer(aSource);
        }
        catch (TransformerConfigurationException ex) {
            s_aLogger.error("Failed to parse " + aSource, (Throwable)ex);
            return null;
        }
    }

    @Nullable
    public static Templates newTemplates(@Nonnull IReadableResource aResource) {
        return XMLTransformerFactory.newTemplates(s_aFactory, aResource);
    }

    @Nullable
    public static Templates newTemplates(@Nonnull Source aSource) {
        return XMLTransformerFactory.newTemplates(s_aFactory, aSource);
    }

    @Nullable
    public static Templates newTemplates(@Nonnull TransformerFactory aFactory, @Nonnull IReadableResource aResource) {
        if (aResource == null) {
            throw new NullPointerException("resource");
        }
        return XMLTransformerFactory.newTemplates(aFactory, TransformSourceFactory.create(aResource));
    }

    @Nullable
    public static Templates newTemplates(@Nonnull TransformerFactory aFactory, @Nonnull Source aSource) {
        if (aFactory == null) {
            throw new NullPointerException("factory");
        }
        if (aSource == null) {
            throw new NullPointerException("source");
        }
        try {
            return aFactory.newTemplates(aSource);
        }
        catch (TransformerConfigurationException ex) {
            s_aLogger.error("Failed to parse " + aSource, (Throwable)ex);
            return null;
        }
    }
}

