/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.exceptions.InitializationException;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.sax.LoggingSAXErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public final class XMLFactory {
    private static DocumentBuilder s_aDefaultDocBuilder;
    private static SAXParserFactory s_aSaxFactoryNonValidating;
    private static SAXParserFactory s_aSaxFactoryValidating;
    private static final XMLFactory s_aInstance;

    private XMLFactory() {
    }

    @Nonnull
    public static DocumentBuilderFactory createDefaultDocumentBuilderFactory() {
        DocumentBuilderFactory aDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
        aDocumentBuilderFactory.setCoalescing(true);
        aDocumentBuilderFactory.setIgnoringComments(true);
        aDocumentBuilderFactory.setNamespaceAware(true);
        return aDocumentBuilderFactory;
    }

    @Nonnull
    public static DocumentBuilder getDocumentBuilder() {
        return s_aDefaultDocBuilder;
    }

    @Nonnull
    public static DOMImplementation getDOMImplementation() {
        return s_aDefaultDocBuilder.getDOMImplementation();
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder(@Nonnull Schema aSchema) {
        if (aSchema == null) {
            throw new NullPointerException("schema");
        }
        try {
            DocumentBuilderFactory aDocBuilderFactory = XMLFactory.createDefaultDocumentBuilderFactory();
            aDocBuilderFactory.setSchema(aSchema);
            DocumentBuilder aDocBuilder = aDocBuilderFactory.newDocumentBuilder();
            aDocBuilder.setErrorHandler(LoggingSAXErrorHandler.getInstance());
            return aDocBuilder;
        }
        catch (ParserConfigurationException ex) {
            throw new InitializationException("Failed to create document builder", ex);
        }
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder() {
        try {
            DocumentBuilderFactory aDocBuilderFactory = XMLFactory.createDefaultDocumentBuilderFactory();
            DocumentBuilder aDocBuilder = aDocBuilderFactory.newDocumentBuilder();
            aDocBuilder.setErrorHandler(LoggingSAXErrorHandler.getInstance());
            return aDocBuilder;
        }
        catch (ParserConfigurationException ex) {
            throw new InitializationException("Failed to create document builder", ex);
        }
    }

    @Nonnull
    public static SAXParserFactory getSaxParserFactory(boolean bValidating) {
        return bValidating ? s_aSaxFactoryValidating : s_aSaxFactoryNonValidating;
    }

    @Nonnull
    public static SAXParser createSaxParser(boolean bValidating) {
        try {
            return XMLFactory.getSaxParserFactory(bValidating).newSAXParser();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to create new SAX parser", t);
        }
    }

    @Nonnull
    public static Document newDocument() {
        return XMLFactory.newDocument(null);
    }

    @Nonnull
    public static Document newDocument(@Nullable EXMLVersion eVersion) {
        Document doc = s_aDefaultDocBuilder.newDocument();
        doc.setXmlVersion((eVersion != null ? eVersion : EXMLVersion.DEFAULT).getVersion());
        return doc;
    }

    @Nonnull
    public static Document newDocument(@Nonnull String sQualifiedName, @Nullable String sPublicId, @Nullable String sSystemId) {
        return XMLFactory.newDocument(null, sQualifiedName, sPublicId, sSystemId);
    }

    @Nonnull
    public static Document newDocument(@Nullable EXMLVersion eVersion, @Nonnull String sQualifiedName, @Nullable String sPublicId, @Nullable String sSystemId) {
        DOMImplementation aDomImpl = XMLFactory.getDOMImplementation();
        DocumentType aDocType = aDomImpl.createDocumentType(sQualifiedName, sPublicId, sSystemId);
        Document doc = aDomImpl.createDocument(sSystemId, sQualifiedName, aDocType);
        doc.setXmlVersion((eVersion != null ? eVersion : EXMLVersion.DEFAULT).getVersion());
        return doc;
    }

    static {
        try {
            s_aDefaultDocBuilder = XMLFactory.createDefaultDocumentBuilderFactory().newDocumentBuilder();
            s_aDefaultDocBuilder.setErrorHandler(LoggingSAXErrorHandler.getInstance());
        }
        catch (ParserConfigurationException ex) {
            throw new InitializationException("Failed to create document builder", ex);
        }
        try {
            s_aSaxFactoryNonValidating = SAXParserFactory.newInstance();
            s_aSaxFactoryNonValidating.setNamespaceAware(true);
            s_aSaxFactoryValidating = SAXParserFactory.newInstance();
            s_aSaxFactoryValidating.setNamespaceAware(true);
            s_aSaxFactoryValidating.setValidating(true);
        }
        catch (FactoryConfigurationError ex) {
            throw new InitializationException("Failed to create SAX parser factory", ex);
        }
        s_aInstance = new XMLFactory();
    }
}

