/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.vminit;

import com.phloc.commons.annotations.CodingStyleguideUnaware;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.lang.ServiceLoaderBackport;
import com.phloc.commons.mock.IMockException;
import com.phloc.commons.vminit.IVirtualMachineEventSPI;
import java.util.List;

public final class VirtualMachineInitializer {
    private static final List<IVirtualMachineEventSPI> s_aSPIs = ContainerHelper.newList(ServiceLoaderBackport.load(IVirtualMachineEventSPI.class));
    private static volatile Thread s_aShutdownThread;
    private static final VirtualMachineInitializer s_aInstance;

    private VirtualMachineInitializer() {
    }

    private static void _init() {
        for (IVirtualMachineEventSPI aSPI : s_aSPIs) {
            try {
                aSPI.onVirtualMachineStart();
            }
            catch (Throwable t) {
                System.err.println("!!! Error running VM initializer SPI " + aSPI);
                if (t instanceof IMockException) continue;
                t.printStackTrace(System.err);
            }
        }
    }

    private static void _done() {
        for (IVirtualMachineEventSPI aSPI : s_aSPIs) {
            try {
                aSPI.onVirtualMachineStop();
            }
            catch (Throwable t) {
                System.err.println("!!! Error running VM shutdown SPI " + aSPI);
                if (t instanceof IMockException) continue;
                t.printStackTrace(System.err);
            }
        }
        s_aShutdownThread = null;
        s_aSPIs.clear();
    }

    @CodingStyleguideUnaware(value="FindBugs claims that we do need synchronized here!")
    public static synchronized void runInitialization() {
        if (s_aSPIs != null && !s_aSPIs.isEmpty()) {
            if (s_aShutdownThread != null) {
                throw new IllegalStateException("Already initialized!");
            }
            VirtualMachineInitializer._init();
            s_aShutdownThread = new Thread("VirtualMachineInitializer.shutdown"){

                @Override
                public void run() {
                    VirtualMachineInitializer._done();
                }
            };
            Runtime.getRuntime().addShutdownHook(s_aShutdownThread);
        }
    }

    static {
        s_aInstance = new VirtualMachineInitializer();
    }
}

