/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert.impl;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.typeconvert.ITypeConverter;
import com.phloc.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.phloc.commons.typeconvert.ITypeConverterRegistry;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleAssignableSourceFixedDestination;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class DateTimeTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry aRegistry) {
        aRegistry.registerTypeConverter(Calendar.class, String.class, new ITypeConverter(){

            @Override
            @Nonnull
            public String convert(@Nonnull Object aSource) {
                return Long.toString(((Calendar)aSource).getTimeInMillis());
            }
        });
        aRegistry.registerTypeConverter(Calendar.class, Long.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Long convert(@Nonnull Object aSource) {
                return ((Calendar)aSource).getTimeInMillis();
            }
        });
        aRegistry.registerTypeConverter(Calendar.class, Date.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Date convert(@Nonnull Object aSource) {
                return ((Calendar)aSource).getTime();
            }
        });
        aRegistry.registerTypeConverter(String.class, Calendar.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Calendar convert(@Nonnull Object aSource) {
                Calendar aCal = Calendar.getInstance();
                aCal.setTimeInMillis(StringParser.parseLong((String)aSource, 0L));
                return aCal;
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Calendar.class){

            @Override
            @Nonnull
            public Calendar convert(@Nonnull Object aSource) {
                Calendar aCal = Calendar.getInstance();
                aCal.setTimeInMillis(((Number)aSource).longValue());
                return aCal;
            }
        });
        aRegistry.registerTypeConverter(Date.class, Calendar.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Calendar convert(@Nonnull Object aSource) {
                Calendar aCal = Calendar.getInstance();
                aCal.setTime((Date)aSource);
                return aCal;
            }
        });
        aRegistry.registerTypeConverter(Date.class, String.class, new ITypeConverter(){

            @Override
            @Nonnull
            public String convert(@Nonnull Object aSource) {
                return Long.toString(((Date)aSource).getTime());
            }
        });
        aRegistry.registerTypeConverter(Date.class, Long.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Long convert(@Nonnull Object aSource) {
                return ((Date)aSource).getTime();
            }
        });
        aRegistry.registerTypeConverter(String.class, Date.class, new ITypeConverter(){

            @Override
            @Nonnull
            public Date convert(@Nonnull Object aSource) {
                return new Date(StringParser.parseLong((String)aSource, 0L));
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Date.class){

            @Override
            @Nonnull
            public Date convert(@Nonnull Object aSource) {
                return new Date(((Number)aSource).longValue());
            }
        });
    }
}

