/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert.impl;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.typeconvert.ITypeConverter;
import com.phloc.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.phloc.commons.typeconvert.ITypeConverterRegistry;
import com.phloc.commons.typeconvert.TypeConverter;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleAnySourceFixedDestination;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleAssignableSourceFixedDestination;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleFixedSourceAnyDestination;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRuleFixedSourceAssignableDestination;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class BaseTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry aRegistry) {
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Boolean.class){

            @Override
            public Boolean convert(@Nonnull Object aSource) {
                return ((Number)aSource).intValue() != 0;
            }
        });
        aRegistry.registerTypeConverter(Character.class, Boolean.class, new ITypeConverter(){

            @Override
            public Boolean convert(@Nonnull Object aSource) {
                return ((Character)aSource).charValue() != '\u0000';
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Boolean.class){

            @Override
            public Boolean convert(@Nonnull Object aSource) {
                return StringParser.parseBoolObj(aSource, null);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Byte.class){

            @Override
            public Byte convert(@Nonnull Object aSource) {
                return ((Number)aSource).byteValue();
            }
        });
        aRegistry.registerTypeConverter(Boolean.class, Byte.class, new ITypeConverter(){

            @Override
            public Byte convert(@Nonnull Object aSource) {
                return (Boolean)aSource != false ? (byte)1 : 0;
            }
        });
        aRegistry.registerTypeConverter(Character.class, Byte.class, new ITypeConverter(){

            @Override
            public Byte convert(@Nonnull Object aSource) {
                return (byte)((Character)aSource).charValue();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Byte.class){

            @Override
            public Byte convert(@Nonnull Object aSource) {
                return StringParser.parseByteObj(aSource, (Byte)null);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Character.class){

            @Override
            public Character convert(@Nonnull Object aSource) {
                return Character.valueOf((char)((Number)aSource).intValue());
            }
        });
        aRegistry.registerTypeConverter(Boolean.class, Character.class, new ITypeConverter(){

            @Override
            public Character convert(@Nonnull Object aSource) {
                return Character.valueOf((Boolean)aSource != false ? (char)'\u0001' : '\u0000');
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Character.class){

            @Override
            public Character convert(@Nonnull Object aSource) {
                String sSource = aSource.toString();
                return sSource.length() == 1 ? Character.valueOf(sSource.charAt(0)) : null;
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Double.class){

            @Override
            public Double convert(@Nonnull Object aSource) {
                return ((Number)aSource).doubleValue();
            }
        });
        aRegistry.registerTypeConverter(Boolean.class, Double.class, new ITypeConverter(){

            @Override
            public Double convert(@Nonnull Object aSource) {
                return (Boolean)aSource != false ? 1.0 : 0.0;
            }
        });
        aRegistry.registerTypeConverter(Character.class, Double.class, new ITypeConverter(){

            @Override
            public Double convert(@Nonnull Object aSource) {
                return ((Character)aSource).charValue();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Double.class){

            @Override
            public Double convert(@Nonnull Object aSource) {
                return StringParser.parseDoubleObj(aSource, (Double)null);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Float.class){

            @Override
            public Float convert(@Nonnull Object aSource) {
                return Float.valueOf(((Number)aSource).floatValue());
            }
        });
        aRegistry.registerTypeConverter(Boolean.class, Float.class, new ITypeConverter(){

            @Override
            public Float convert(@Nonnull Object aSource) {
                return Float.valueOf((Boolean)aSource != false ? 1.0f : 0.0f);
            }
        });
        aRegistry.registerTypeConverter(Character.class, Float.class, new ITypeConverter(){

            @Override
            public Float convert(@Nonnull Object aSource) {
                return Float.valueOf(((Character)aSource).charValue());
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Float.class){

            @Override
            public Float convert(@Nonnull Object aSource) {
                return StringParser.parseFloatObj(aSource, (Float)null);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Integer.class){

            @Override
            public Integer convert(@Nonnull Object aSource) {
                return ((Number)aSource).intValue();
            }
        });
        aRegistry.registerTypeConverter(Boolean.class, Integer.class, new ITypeConverter(){

            @Override
            public Integer convert(@Nonnull Object aSource) {
                return (Boolean)aSource != false ? 1 : 0;
            }
        });
        aRegistry.registerTypeConverter(Character.class, Integer.class, new ITypeConverter(){

            @Override
            public Integer convert(@Nonnull Object aSource) {
                return ((Character)aSource).charValue();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Integer.class){

            @Override
            public Integer convert(@Nonnull Object aSource) {
                return StringParser.parseIntObj(aSource, (Integer)null);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Long.class){

            @Override
            public Long convert(@Nonnull Object aSource) {
                return ((Number)aSource).longValue();
            }
        });
        aRegistry.registerTypeConverter(Boolean.class, Long.class, new ITypeConverter(){

            @Override
            public Long convert(@Nonnull Object aSource) {
                return (Boolean)aSource != false ? 1L : 0L;
            }
        });
        aRegistry.registerTypeConverter(Character.class, Long.class, new ITypeConverter(){

            @Override
            public Long convert(@Nonnull Object aSource) {
                return ((Character)aSource).charValue();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Long.class){

            @Override
            public Long convert(@Nonnull Object aSource) {
                return StringParser.parseLongObj(aSource, (Long)null);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, Short.class){

            @Override
            public final Short convert(@Nonnull Object aSource) {
                return ((Number)aSource).shortValue();
            }
        });
        aRegistry.registerTypeConverter(Boolean.class, Short.class, new ITypeConverter(){

            @Override
            public Short convert(@Nonnull Object aSource) {
                return (Boolean)aSource != false ? (short)1 : 0;
            }
        });
        aRegistry.registerTypeConverter(Character.class, Short.class, new ITypeConverter(){

            @Override
            public Short convert(@Nonnull Object aSource) {
                return (short)((Character)aSource).charValue();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(Short.class){

            @Override
            public Short convert(@Nonnull Object aSource) {
                return StringParser.parseShortObj(aSource, (Short)null);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(String.class){

            @Override
            public String convert(@Nonnull Object aSource) {
                return aSource.toString();
            }
        });
        aRegistry.registerTypeConverter(BigInteger.class, BigDecimal.class, new ITypeConverter(){

            @Override
            public BigDecimal convert(@Nonnull Object aSource) {
                return new BigDecimal((BigInteger)aSource);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, BigDecimal.class){

            @Override
            public BigDecimal convert(@Nonnull Object aSource) {
                return BigDecimal.valueOf(((Number)aSource).doubleValue());
            }
        });
        aRegistry.registerTypeConverter(Boolean.class, BigDecimal.class, new ITypeConverter(){

            @Override
            public BigDecimal convert(@Nonnull Object aSource) {
                return (Boolean)aSource != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
        });
        aRegistry.registerTypeConverter(Character.class, BigDecimal.class, new ITypeConverter(){

            @Override
            public BigDecimal convert(@Nonnull Object aSource) {
                return BigDecimal.valueOf(((Character)aSource).charValue());
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(BigDecimal.class){

            @Override
            public BigDecimal convert(@Nonnull Object aSource) {
                return StringParser.parseBigDecimal(aSource.toString(), null);
            }
        });
        aRegistry.registerTypeConverter(BigDecimal.class, BigInteger.class, new ITypeConverter(){

            @Override
            public BigInteger convert(@Nonnull Object aSource) {
                return ((BigDecimal)aSource).toBigInteger();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Number.class, BigInteger.class){

            @Override
            public BigInteger convert(@Nonnull Object aSource) {
                return BigInteger.valueOf(((Number)aSource).longValue());
            }
        });
        aRegistry.registerTypeConverter(Boolean.class, BigInteger.class, new ITypeConverter(){

            @Override
            public BigInteger convert(@Nonnull Object aSource) {
                return (Boolean)aSource != false ? BigInteger.ONE : BigInteger.ZERO;
            }
        });
        aRegistry.registerTypeConverter(Character.class, BigInteger.class, new ITypeConverter(){

            @Override
            public BigInteger convert(@Nonnull Object aSource) {
                return BigInteger.valueOf(((Character)aSource).charValue());
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(BigInteger.class){

            @Override
            public BigInteger convert(@Nonnull Object aSource) {
                return StringParser.parseBigInteger(aSource.toString(), null);
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleFixedSourceAnyDestination(AtomicBoolean.class){

            @Override
            protected Object getInBetweenValue(@Nonnull Object aSource) {
                return ((AtomicBoolean)aSource).get();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(AtomicBoolean.class){

            @Override
            public AtomicBoolean convert(@Nonnull Object aSource) {
                return new AtomicBoolean(TypeConverter.convertIfNecessary(aSource, Boolean.class));
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleFixedSourceAnyDestination(AtomicInteger.class){

            @Override
            protected Object getInBetweenValue(@Nonnull Object aSource) {
                return ((AtomicInteger)aSource).get();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(AtomicInteger.class){

            @Override
            public AtomicInteger convert(@Nonnull Object aSource) {
                return new AtomicInteger(TypeConverter.convertIfNecessary(aSource, Integer.class));
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleFixedSourceAnyDestination(AtomicLong.class){

            @Override
            protected Object getInBetweenValue(@Nonnull Object aSource) {
                return ((AtomicLong)aSource).get();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(AtomicLong.class){

            @Override
            public AtomicLong convert(@Nonnull Object aSource) {
                return new AtomicLong(TypeConverter.convertIfNecessary(aSource, Long.class));
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(StringBuilder.class){

            @Override
            public StringBuilder convert(@Nonnull Object aSource) {
                if (aSource instanceof CharSequence) {
                    return new StringBuilder((CharSequence)aSource);
                }
                return new StringBuilder(TypeConverter.convertIfNecessary(aSource, String.class));
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAnySourceFixedDestination(StringBuffer.class){

            @Override
            public StringBuffer convert(@Nonnull Object aSource) {
                if (aSource instanceof CharSequence) {
                    return new StringBuffer((CharSequence)aSource);
                }
                return new StringBuffer(TypeConverter.convertIfNecessary(aSource, String.class));
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleAssignableSourceFixedDestination(Enum.class, String.class){

            @Override
            @Nonnull
            public String convert(@Nonnull Object aSource) {
                return aSource.getClass().getName() + ':' + ((Enum)aSource).name();
            }
        });
        aRegistry.registerTypeConverterRule(new AbstractTypeConverterRuleFixedSourceAssignableDestination(String.class, Enum.class){

            @Override
            public Enum<?> convert(@Nonnull Object aSource) {
                List<String> aParts = StringHelper.getExploded(':', (String)aSource, 2);
                try {
                    Class aClass = GenericReflection.getClassFromName(aParts.get(0));
                    return Enum.valueOf(aClass, aParts.get(1));
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }
        });
    }
}

