/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.sort;

import com.phloc.commons.hierarchy.DefaultHierarchyWalkerCallback;
import com.phloc.commons.tree.IBasicTree;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemID;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemIDComparable;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemValue;
import com.phloc.commons.tree.utils.sort.ComparatorTreeItemValueComparable;
import com.phloc.commons.tree.utils.walk.TreeWalker;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWithIDSorter {
    private static final TreeWithIDSorter s_aInstance = new TreeWithIDSorter();

    private TreeWithIDSorter() {
    }

    private static <KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void _sort(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, final @Nonnull Comparator<? super ITEMTYPE> aComparator) {
        if (aTree == null) {
            throw new NullPointerException("tree");
        }
        if (aComparator == null) {
            throw new NullPointerException("comparator");
        }
        ((ITreeItemWithID)aTree.getRootItem()).reorderChildrenByItems(aComparator);
        TreeWalker.walkTree(aTree, new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void onItemBeforeChildren(@Nullable ITEMTYPE aTreeItem) {
                if (aTreeItem != null) {
                    aTreeItem.reorderChildrenByItems(aComparator);
                }
            }
        });
    }

    public static <KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void sortByID(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nonnull Comparator<? super KEYTYPE> aKeyComparator) {
        ComparatorTreeItemID aItemComp = new ComparatorTreeItemID(aKeyComparator);
        TreeWithIDSorter._sort(aTree, aItemComp);
    }

    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void sortByID(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree) {
        ComparatorTreeItemIDComparable aItemComp = new ComparatorTreeItemIDComparable();
        TreeWithIDSorter._sort(aTree, aItemComp);
    }

    public static <KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void sortByValue(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nonnull Comparator<? super VALUETYPE> aValueComparator) {
        ComparatorTreeItemValue aItemComp = new ComparatorTreeItemValue(aValueComparator);
        TreeWithIDSorter._sort(aTree, aItemComp);
    }

    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void sortByValue(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree) {
        ComparatorTreeItemValueComparable aItemComp = new ComparatorTreeItemValueComparable();
        TreeWithIDSorter._sort(aTree, aItemComp);
    }
}

