/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.simple;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.simple.ITreeItem;
import com.phloc.commons.tree.simple.ITreeItemFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTreeItem<VALUETYPE, ITEMTYPE extends ITreeItem<VALUETYPE, ITEMTYPE>>
implements ITreeItem<VALUETYPE, ITEMTYPE> {
    private final ITreeItemFactory<VALUETYPE, ITEMTYPE> m_aFactory;
    private ITEMTYPE m_aParent;
    private VALUETYPE m_aData;
    private List<ITEMTYPE> m_aChildren = null;

    public BasicTreeItem(@Nonnull ITreeItemFactory<VALUETYPE, ITEMTYPE> aFactory) {
        if (aFactory == null) {
            throw new NullPointerException("factory");
        }
        this.m_aFactory = aFactory;
        this.m_aParent = null;
        this.m_aData = null;
    }

    public BasicTreeItem(@Nonnull ITEMTYPE aParent) {
        if (aParent == null) {
            throw new NullPointerException("parent");
        }
        if (!(aParent instanceof BasicTreeItem)) {
            throw new IllegalArgumentException("Parent is no BasicTreeItem");
        }
        if (aParent.getFactory() == null) {
            throw new IllegalStateException("parent item has no factory");
        }
        this.m_aParent = aParent;
        this.m_aFactory = aParent.getFactory();
        this.m_aData = null;
    }

    @Override
    @Nonnull
    public final ITreeItemFactory<VALUETYPE, ITEMTYPE> getFactory() {
        return this.m_aFactory;
    }

    @OverrideOnDemand
    protected boolean isValidData(VALUETYPE aData) {
        return true;
    }

    @Override
    @Nullable
    public final VALUETYPE getData() {
        return this.m_aData;
    }

    @Override
    public final void setData(@Nullable VALUETYPE aData) {
        if (!this.isValidData(aData)) {
            throw new IllegalArgumentException("The passed data object is invalid!");
        }
        this.m_aData = aData;
    }

    @Override
    public final boolean isRootItem() {
        return this.m_aParent == null;
    }

    @Override
    @Nullable
    public final ITEMTYPE getParent() {
        return this.m_aParent;
    }

    @Nonnull
    private ITEMTYPE _asT(@Nonnull BasicTreeItem<VALUETYPE, ITEMTYPE> aItem) {
        return (ITEMTYPE)((ITreeItem)GenericReflection.uncheckedCast(aItem));
    }

    @Override
    @Nonnull
    public final ITEMTYPE createChildItem(@Nullable VALUETYPE aData) {
        ITEMTYPE aItem = this.m_aFactory.create(this._asT(this));
        if (aItem == null) {
            throw new IllegalStateException("null item created!");
        }
        aItem.setData(aData);
        this.internalAddChild(aItem);
        return aItem;
    }

    @Override
    public final boolean hasChildren() {
        return this.m_aChildren != null && !this.m_aChildren.isEmpty();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public final List<ITEMTYPE> getChildren() {
        return this.m_aChildren == null ? null : ContainerHelper.newList(this.m_aChildren);
    }

    @Override
    @Nullable
    public final ITEMTYPE getChildAtIndex(@Nonnegative int nIndex) {
        if (this.m_aChildren == null) {
            throw new IndexOutOfBoundsException("Tree item has no children!");
        }
        return (ITEMTYPE)((ITreeItem)this.m_aChildren.get(nIndex));
    }

    @Override
    @Nonnegative
    public final int getChildCount() {
        return this.m_aChildren != null ? this.m_aChildren.size() : 0;
    }

    @Override
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public final boolean isSameOrChildOf(@Nonnull ITEMTYPE aParent) {
        if (aParent == null) {
            throw new NullPointerException("parent");
        }
        for (ITreeItem<VALUETYPE, ITEMTYPE> aCur = this; aCur != null; aCur = (ITreeItem)aCur.getParent()) {
            if (aCur != aParent) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public final ESuccess changeParent(@Nonnull ITEMTYPE aNewParent) {
        if (aNewParent == null) {
            throw new NullPointerException("newParent");
        }
        if (this.getParent() == aNewParent) {
            return ESuccess.SUCCESS;
        }
        ITEMTYPE aThis = this._asT(this);
        if (aNewParent.isSameOrChildOf(aThis)) {
            return ESuccess.FAILURE;
        }
        if (this.getParent().removeChild(aThis).isUnchanged()) {
            throw new IllegalStateException("Failed to remove this from parent!");
        }
        this.m_aParent = aNewParent;
        return ESuccess.valueOfChange(aNewParent.internalAddChild(aThis));
    }

    @Override
    @Nonnull
    public final EChange internalAddChild(@Nonnull ITEMTYPE aChild) {
        if (aChild == null) {
            throw new NullPointerException("child");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new ArrayList<ITEMTYPE>();
        }
        return EChange.valueOf(this.m_aChildren.add(aChild));
    }

    @Override
    @Nonnull
    public final EChange removeChild(@Nonnull ITEMTYPE aChild) {
        if (aChild == null) {
            throw new NullPointerException("child");
        }
        return EChange.valueOf(this.m_aChildren != null && this.m_aChildren.remove(aChild));
    }

    @Override
    public final void reorderChildItems(@Nonnull Comparator<? super ITEMTYPE> aComparator) {
        if (this.m_aChildren != null) {
            this.m_aChildren = ContainerHelper.getSorted(this.m_aChildren, aComparator);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicTreeItem)) {
            return false;
        }
        BasicTreeItem rhs = (BasicTreeItem)o;
        return EqualsUtils.equals(this.m_aData, rhs.m_aData) && EqualsUtils.equals(this.m_aChildren, rhs.m_aChildren);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aData).append(this.m_aChildren)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("data", this.m_aData).append("children", this.m_aChildren).toString();
    }
}

