/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.thirdparty;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.thirdparty.ILicense;
import com.phloc.commons.version.Version;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ELicense implements ILicense
{
    APACHE1("apache1", "Apache License", new Version(1, 0), "http://www.apache.org/licenses/LICENSE-1.0.txt"),
    APACHE2("apache2", "Apache License", new Version(2, 0), "http://www.apache.org/licenses/LICENSE-2.0.txt"),
    MPL11("mpl11", "MOZILLA PUBLIC LICENSE", new Version(1, 1), "http://www.mozilla.org/MPL/MPL-1.1.txt"),
    BSD("bsd", "The BSD License", null, "http://www.opensource.org/licenses/bsd-license.php"),
    MIT("mit", "MIT License", null, "http://www.opensource.org/licenses/mit-license.php"),
    GPL20("gpl20", "GNU GENERAL PUBLIC LICENSE", new Version(2, 0), "http://www.gnu.org/licenses/old-licenses/gpl-2.0.html"),
    GPL30("gpl30", "GNU GENERAL PUBLIC LICENSE", new Version(3, 0), "http://www.gnu.org/licenses/gpl.html"),
    LGPL20("lgpl20", "GNU LIBRARY GENERAL PUBLIC LICENSE", new Version(2, 0), "http://www.gnu.org/licenses/old-licenses/lgpl-2.0.html"),
    LGPL21("lgpl21", "GNU LESSER GENERAL PUBLIC LICENSE", new Version(2, 1), "http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html"),
    LGPL30("lgpl30", "GNU LESSER GENERAL PUBLIC LICENSE", new Version(3, 0), "http://www.gnu.org/licenses/lgpl.html"),
    EPL10("epl10", "Eclipse Public License", new Version(1, 0), "http://www.eclipse.org/legal/epl-v10.html"),
    EUPL11("eupl11", "The European Union Public License", new Version(1, 1), "http://www.osor.eu/eupl"),
    CCBY10("ccby10", "Creative Commons Attributation", new Version(1, 0), "http://creativecommons.org/licenses/by/1.0/"),
    CCBY20("ccby20", "Creative Commons Attributation", new Version(2, 0), "http://creativecommons.org/licenses/by/2.0/"),
    CCBY25("ccby25", "Creative Commons Attributation", new Version(2, 5), "http://creativecommons.org/licenses/by/2.5/"),
    CCBY30("ccby30", "Creative Commons Attributation", new Version(3, 0), "http://creativecommons.org/licenses/by/3.0/"),
    PUBLIC_DOMAIN("pd", "Public Domain", null, null);

    private final String m_sID;
    private final String m_sName;
    private final Version m_aVersion;
    private final String m_sURL;

    private ELicense(@Nullable String sID, @Nullable String sName, Version aVersion, String sURL) {
        this.m_sID = sID;
        this.m_sName = sName;
        this.m_aVersion = aVersion;
        this.m_sURL = sURL;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sName;
    }

    @Override
    @Nullable
    public Version getVersion() {
        return this.m_aVersion;
    }

    @Override
    @Nullable
    public String getURL() {
        return this.m_sURL;
    }

    @Nullable
    public static ELicense getFromIDOrNull(@Nullable String sID) {
        return EnumHelper.getFromIDOrNull(ELicense.class, sID);
    }
}

