/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.impl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.callback.IChangeNotify;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.locale.LocaleCache;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.text.IMultiLingualText;
import com.phloc.commons.text.IReadonlyMultiLingualText;
import com.phloc.commons.text.ISimpleMultiLingualText;
import com.phloc.commons.text.impl.MultiLingualText;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MultiLingualTextThreadSafe
implements IMultiLingualText {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final MultiLingualText m_aMLT;

    public MultiLingualTextThreadSafe() {
        this.m_aMLT = new MultiLingualText();
    }

    public MultiLingualTextThreadSafe(@Nonnull ISimpleMultiLingualText aSimpleMLT) {
        if (aSimpleMLT == null) {
            throw new NullPointerException("MLT");
        }
        this.m_aMLT = new MultiLingualText(aSimpleMLT);
    }

    public MultiLingualTextThreadSafe(@Nonnull IReadonlyMultiLingualText aMLT) {
        if (aMLT == null) {
            throw new NullPointerException("mlt");
        }
        this.m_aMLT = new MultiLingualText(aMLT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getText(Locale aContentLocale) {
        this.m_aRWLock.readLock().lock();
        try {
            String string = this.m_aMLT.getText(aContentLocale);
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getTextWithLocaleFallback(Locale aContentLocale) {
        this.m_aRWLock.readLock().lock();
        try {
            String string = this.m_aMLT.getTextWithLocaleFallback(aContentLocale);
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getTextWithArgs(Locale aContentLocale, Object ... aArgs) {
        this.m_aRWLock.readLock().lock();
        try {
            String string = this.m_aMLT.getTextWithArgs(aContentLocale, aArgs);
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getTextWithLocaleFallbackAndArgs(Locale aContentLocale, Object ... aArgs) {
        this.m_aRWLock.readLock().lock();
        try {
            String string = this.m_aMLT.getTextWithLocaleFallbackAndArgs(aContentLocale, aArgs);
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange addText(Locale aContentLocale, @Nullable String sText) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aMLT.addText(aContentLocale, sText);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setText(Locale aContentLocale, @Nullable String sText) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aMLT.setText(aContentLocale, sText);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsLocale(Locale aContentLocale) {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aMLT.containsLocale(aContentLocale);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsLocaleWithFallback(Locale aContentLocale) {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aMLT.containsLocaleWithFallback(aContentLocale);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<Locale, String> getMap() {
        this.m_aRWLock.readLock().lock();
        try {
            Map<Locale, String> map = ContainerHelper.newMap(this.m_aMLT.internalGetMap());
            return map;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnegative
    public int size() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aMLT.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aMLT.isEmpty();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public Set<Locale> getAllLocales() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<Locale> set = ContainerHelper.newSet(this.m_aMLT.internalGetAllLocales());
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange removeText(@Nonnull Locale aContentLocale) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aMLT.removeText(aContentLocale);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange clear() {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aMLT.clear();
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange assignFrom(@Nonnull IReadonlyMultiLingualText aMLT) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = this.m_aMLT.assignFrom(aMLT);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeNotifier(@Nonnull IChangeNotify<IMultiLingualText> aCallback) {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMLT.addChangeNotifier(aCallback);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiLingualTextThreadSafe)) {
            return false;
        }
        MultiLingualTextThreadSafe rhs = (MultiLingualTextThreadSafe)o;
        return this.m_aMLT.equals(rhs.m_aMLT);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aMLT).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("mlt", this.m_aMLT).toString();
    }

    @Nonnull
    public static IMultiLingualText createFromMap(@Nonnull Map<String, String> aMap) {
        MultiLingualTextThreadSafe ret = new MultiLingualTextThreadSafe();
        for (Map.Entry<String, String> aEntry : aMap.entrySet()) {
            String sText = aEntry.getValue();
            if (sText == null) continue;
            ret.setText(LocaleCache.getLocale(aEntry.getKey()), sText);
        }
        return ret;
    }
}

