/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.stats.visit;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.stats.IStatisticsHandler;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedSize;
import com.phloc.commons.stats.IStatisticsHandlerKeyedTimer;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.stats.visit.IStatisticsVisitor;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StatisticsWalker {
    private static final StatisticsWalker s_aInstance = new StatisticsWalker();

    private StatisticsWalker() {
    }

    public static void walkStatistics(@Nonnull IStatisticsVisitor aVisitor) {
        IStatisticsHandler aHandler;
        if (aVisitor == null) {
            throw new NullPointerException("visitor");
        }
        List<String> aHandlers = ContainerHelper.getSorted(StatisticsManager.getAllCacheHandler());
        for (String sName : aHandlers) {
            aHandler = StatisticsManager.getCacheHandler(sName);
            aVisitor.onCache(sName, (IStatisticsHandlerCache)aHandler);
        }
        aHandlers = ContainerHelper.getSorted(StatisticsManager.getAllTimerHandler());
        for (String sName : aHandlers) {
            aHandler = StatisticsManager.getTimerHandler(sName);
            aVisitor.onTimer(sName, (IStatisticsHandlerTimer)aHandler);
        }
        aHandlers = ContainerHelper.getSorted(StatisticsManager.getAllKeyedTimerHandler());
        for (String sName : aHandlers) {
            aHandler = StatisticsManager.getKeyedTimerHandler(sName);
            aVisitor.onKeyedTimer(sName, (IStatisticsHandlerKeyedTimer)aHandler);
        }
        aHandlers = ContainerHelper.getSorted(StatisticsManager.getAllSizeHandler());
        for (String sName : aHandlers) {
            aHandler = StatisticsManager.getSizeHandler(sName);
            aVisitor.onSize(sName, (IStatisticsHandlerSize)aHandler);
        }
        aHandlers = ContainerHelper.getSorted(StatisticsManager.getAllKeyedSizeHandler());
        for (String sName : aHandlers) {
            aHandler = StatisticsManager.getKeyedSizeHandler(sName);
            aVisitor.onKeyedSize(sName, (IStatisticsHandlerKeyedSize)aHandler);
        }
        aHandlers = ContainerHelper.getSorted(StatisticsManager.getAllCounterHandler());
        for (String sName : aHandlers) {
            aHandler = StatisticsManager.getCounterHandler(sName);
            aVisitor.onCounter(sName, (IStatisticsHandlerCounter)aHandler);
        }
        aHandlers = ContainerHelper.getSorted(StatisticsManager.getAllKeyedCounterHandler());
        for (String sName : aHandlers) {
            aHandler = StatisticsManager.getKeyedCounterHandler(sName);
            aVisitor.onKeyedCounter(sName, (IStatisticsHandlerKeyedCounter)aHandler);
        }
    }
}

