/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.pool;

import com.phloc.commons.factory.IFactory;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.pool.IObjectPool;
import com.phloc.commons.state.ESuccess;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ObjectPool<DATATYPE>
implements IObjectPool<DATATYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ObjectPool.class);
    private final Lock m_aLock = new ReentrantLock();
    private final Semaphore m_aAvailable;
    private final Object[] m_aItems;
    private final boolean[] m_aUsed;
    private final IFactory<DATATYPE> m_aFactory;

    public ObjectPool(@Nonnegative int nItemCount, @Nonnull IFactory<DATATYPE> aFactory) {
        if (nItemCount < 1) {
            throw new IllegalArgumentException("Item count " + nItemCount + " is illegal!");
        }
        if (aFactory == null) {
            throw new NullPointerException("factory");
        }
        this.m_aAvailable = new Semaphore(nItemCount, true);
        this.m_aItems = new Object[nItemCount];
        this.m_aUsed = new boolean[nItemCount];
        Arrays.fill(this.m_aUsed, 0, nItemCount, false);
        this.m_aFactory = aFactory;
    }

    @Override
    @Nullable
    public DATATYPE borrowObject() {
        try {
            this.m_aAvailable.acquire();
        }
        catch (InterruptedException ex) {
            s_aLogger.error("ObjectPool interrupted", (Throwable)ex);
            return null;
        }
        this.m_aLock.lock();
        try {
            for (int i = 0; i < this.m_aItems.length; ++i) {
                if (this.m_aUsed[i]) continue;
                if (this.m_aItems[i] == null) {
                    this.m_aItems[i] = this.m_aFactory.create();
                    if (this.m_aItems[i] == null) {
                        throw new IllegalStateException("The factory returned a null object!");
                    }
                }
                this.m_aUsed[i] = true;
                Object DSTTYPE = GenericReflection.uncheckedCast(this.m_aItems[i]);
                return (DATATYPE)DSTTYPE;
            }
            throw new IllegalStateException("Should never be reached!");
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ESuccess returnObject(@Nonnull DATATYPE aItem) {
        this.m_aLock.lock();
        try {
            for (int i = 0; i < this.m_aItems.length; ++i) {
                if (!this.m_aUsed[i] || aItem != this.m_aItems[i]) continue;
                this.m_aUsed[i] = false;
                this.m_aAvailable.release();
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
            s_aLogger.warn("Object " + aItem + " is not pooled!");
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            this.m_aLock.unlock();
        }
    }
}

