/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mock;

import com.phloc.commons.ICloneable;
import com.phloc.commons.io.streamprovider.ByteArrayInputStreamProvider;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.convert.MicroTypeConverter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.junit.Assert;

@Immutable
public final class PhlocTestUtils {
    private static final PhlocTestUtils s_aInstance = new PhlocTestUtils();

    private PhlocTestUtils() {
    }

    private static void _assertTrue(@Nonnull String sMsg, boolean bTrue) {
        if (!bTrue) {
            throw new IllegalStateException(sMsg);
        }
    }

    private static void _assertFalse(@Nonnull String sMsg, boolean bTrue) {
        if (bTrue) {
            throw new IllegalStateException(sMsg);
        }
    }

    private static void _assertNotNull(@Nonnull String sMsg, Object aObj) {
        if (aObj == null) {
            throw new IllegalStateException(sMsg);
        }
    }

    @SuppressFBWarnings(value={"EC_NULL_ARG"})
    private static <DATATYPE> void _testEqualsImplementation(@Nonnull DATATYPE aObject) {
        PhlocTestUtils._assertNotNull("Passed object may not be null!", aObject);
        PhlocTestUtils._assertTrue("Passed objects are not equal", aObject.equals(aObject));
        PhlocTestUtils._assertFalse("Object may no be equal to String", aObject.equals("any string"));
        PhlocTestUtils._assertFalse("Object may no be equal to null", aObject.equals(null));
    }

    private static <DATATYPE> void _testEqualsImplementationWithEqualContentObject(@Nonnull DATATYPE aObject, @Nonnull DATATYPE aObject2) {
        PhlocTestUtils._testEqualsImplementation(aObject);
        PhlocTestUtils._testEqualsImplementation(aObject2);
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", aObject == aObject2);
        PhlocTestUtils._assertTrue("Passed objects are not identical!", aObject.equals(aObject2));
        PhlocTestUtils._assertTrue("Passed objects are not identical!", aObject2.equals(aObject));
    }

    private static <DATATYPE> void _testEqualsImplementationWithDifferentContentObject(@Nonnull DATATYPE aObject, @Nonnull DATATYPE aObject2) {
        PhlocTestUtils._testEqualsImplementation(aObject);
        PhlocTestUtils._testEqualsImplementation(aObject2);
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", aObject == aObject2);
        PhlocTestUtils._assertFalse("Passed objects are identical!", aObject.equals(aObject2));
        PhlocTestUtils._assertFalse("Passed objects are identical!", aObject2.equals(aObject));
    }

    private static <DATATYPE> void _testHashcodeImplementation(@Nonnull DATATYPE aObject) {
        PhlocTestUtils._assertNotNull("Passed object may not be null!", aObject);
        PhlocTestUtils._assertTrue("hashCode() invocations must be consistent", aObject.hashCode() == aObject.hashCode());
        PhlocTestUtils._assertFalse("hashCode() may not be 0", aObject.hashCode() == 0);
    }

    private static <DATATYPE> void _testHashcodeImplementationWithEqualContentObject(@Nonnull DATATYPE aObject, @Nonnull DATATYPE aObject2) {
        PhlocTestUtils._testHashcodeImplementation(aObject);
        PhlocTestUtils._testHashcodeImplementation(aObject2);
        PhlocTestUtils._assertTrue("Passed objects are not identical!", aObject.equals(aObject2));
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", aObject == aObject2);
        PhlocTestUtils._assertTrue("hashCode() invocations must be consistent", aObject.hashCode() == aObject2.hashCode());
        PhlocTestUtils._assertTrue("hashCode() invocations must be consistent", aObject2.hashCode() == aObject.hashCode());
    }

    private static <DATATYPE> void _testHashcodeImplementationWithDifferentContentObject(@Nonnull DATATYPE aObject1, @Nonnull DATATYPE aObject2) {
        PhlocTestUtils._testHashcodeImplementation(aObject1);
        PhlocTestUtils._testHashcodeImplementation(aObject2);
        PhlocTestUtils._assertFalse("Passed objects are identical!", aObject1.equals(aObject2));
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", aObject1 == aObject2);
        int nHash1 = aObject1.hashCode();
        int nHash2 = aObject2.hashCode();
        PhlocTestUtils._assertFalse("hashCode() may not be the same for both objects", nHash1 == nHash2);
    }

    public static <DATATYPE> void testToStringImplementation(@Nonnull DATATYPE aObject) {
        PhlocTestUtils._assertNotNull("Passed object may not be null!", aObject);
        PhlocTestUtils._assertNotNull("toString() may not return null!", aObject.toString());
        PhlocTestUtils._assertTrue("toString() may not return an empty string!", aObject.toString().length() > 0);
        PhlocTestUtils._assertTrue("toString() invocations must be consistent", aObject.toString().equals(aObject.toString()));
    }

    private static <DATATYPE> void _testToStringImplementationWithEqualContentObject(@Nonnull DATATYPE aObject, @Nonnull DATATYPE aObject2) {
        PhlocTestUtils.testToStringImplementation(aObject);
        PhlocTestUtils.testToStringImplementation(aObject2);
        PhlocTestUtils._assertTrue("Passed objects are not identical!", aObject.equals(aObject2));
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", aObject == aObject2);
    }

    private static <DATATYPE> void _testToStringImplementationWithDifferentContentObject(@Nonnull DATATYPE aObject, @Nonnull DATATYPE aObject2) {
        PhlocTestUtils.testToStringImplementation(aObject);
        PhlocTestUtils.testToStringImplementation(aObject2);
        PhlocTestUtils._assertFalse("Passed objects are identical!", aObject.equals(aObject2));
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", aObject == aObject2);
    }

    public static <DATATYPE> void testDefaultImplementationWithEqualContentObject(@Nonnull DATATYPE aObject1, @Nonnull DATATYPE aObject2) {
        PhlocTestUtils._testEqualsImplementationWithEqualContentObject(aObject1, aObject2);
        PhlocTestUtils._testHashcodeImplementationWithEqualContentObject(aObject1, aObject2);
        PhlocTestUtils._testToStringImplementationWithEqualContentObject(aObject1, aObject2);
    }

    public static <DATATYPE> void testDefaultImplementationWithDifferentContentObject(@Nonnull DATATYPE aObject1, @Nonnull DATATYPE aObject2) {
        PhlocTestUtils._testEqualsImplementationWithDifferentContentObject(aObject1, aObject2);
        PhlocTestUtils._testHashcodeImplementationWithDifferentContentObject(aObject1, aObject2);
        PhlocTestUtils._testToStringImplementationWithDifferentContentObject(aObject1, aObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static <DATATYPE extends Serializable> DATATYPE testDefaultSerialization(@Nonnull DATATYPE aSerializable) {
        try {
            Serializable aReadObject;
            NonBlockingByteArrayOutputStream aBAOS = new NonBlockingByteArrayOutputStream();
            ObjectOutputStream aOOS = new ObjectOutputStream(aBAOS);
            try {
                aOOS.writeObject(aSerializable);
            }
            finally {
                StreamUtils.close(aOOS);
            }
            ObjectInputStream aOIS = new ObjectInputStream(new ByteArrayInputStreamProvider(aBAOS.toByteArray()).getInputStream());
            try {
                aReadObject = (Serializable)GenericReflection.uncheckedCast(aOIS.readObject());
            }
            finally {
                StreamUtils.close(aOIS);
            }
            PhlocTestUtils.testDefaultImplementationWithEqualContentObject(aSerializable, aReadObject);
            return (DATATYPE)aReadObject;
        }
        catch (Throwable t) {
            throw new IllegalStateException("testDefaultSerialization failed", t);
        }
    }

    public static void testGetClone(@Nonnull ICloneable<?> aCloneable) {
        Object aClone = aCloneable.getClone();
        PhlocTestUtils._assertNotNull("Clone returned a null object", aClone);
        PhlocTestUtils._assertTrue("Clone returned a different class than the original one", aClone.getClass().equals(aCloneable.getClass()));
        PhlocTestUtils.testDefaultImplementationWithEqualContentObject(aCloneable, aClone);
    }

    public static void testMicroTypeConversion(@Nonnull Object aObj) {
        Assert.assertNotNull((Object)aObj);
        IMicroElement e = MicroTypeConverter.convertToMicroElement(aObj, "test");
        Assert.assertNotNull((Object)e);
        Object o2 = MicroTypeConverter.convertToNative(e, aObj.getClass());
        Assert.assertNotNull(o2);
        PhlocTestUtils.testDefaultImplementationWithEqualContentObject(aObj, o2);
    }
}

