/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.microdom.EMicroNodeType;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.IMicroText;
import com.phloc.commons.microdom.impl.AbstractMicroNodeWithChildren;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.typeconvert.TypeConverter;
import com.phloc.commons.xml.CXMLRegEx;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroElement
extends AbstractMicroNodeWithChildren
implements IMicroElement {
    private String m_sNamespaceURI;
    private final String m_sTagName;
    private Map<String, String> m_aAttrs;

    public MicroElement(@Nonnull @Nonempty String sTagName) {
        this(null, sTagName);
    }

    public MicroElement(@Nullable String sNamespaceURI, @Nonnull @Nonempty String sTagName) {
        if (StringHelper.hasNoText(sTagName)) {
            throw new IllegalArgumentException("No valid tag name specified");
        }
        this.m_sNamespaceURI = sNamespaceURI;
        int nPrefixEnd = sNamespaceURI != null ? sTagName.indexOf(58) : -1;
        String string = this.m_sTagName = nPrefixEnd == -1 ? sTagName : sTagName.substring(nPrefixEnd + 1);
        if (GlobalDebug.isDebugMode() && !CXMLRegEx.PATTERN_NAME.matcher(this.m_sTagName).matches()) {
            throw new IllegalArgumentException("The passed element name '" + this.m_sTagName + "' is not a valid element name!");
        }
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.ELEMENT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return this.m_sTagName;
    }

    @Override
    public boolean hasAttributes() {
        return this.m_aAttrs != null && !this.m_aAttrs.isEmpty();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public Map<String, String> getAttributes() {
        return this.hasAttributes() ? ContainerHelper.newOrderedMap(this.m_aAttrs) : null;
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String sAttrName) {
        return this.m_aAttrs == null ? null : this.m_aAttrs.get(sAttrName);
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE getAttributeWithConversion(@Nullable String sAttrName, @Nonnull Class<DSTTYPE> aDstClass) {
        String sAttrVal = this.getAttribute(sAttrName);
        if (StringHelper.hasNoText(sAttrVal)) {
            return null;
        }
        DSTTYPE ret = TypeConverter.convertIfNecessary(sAttrVal, aDstClass);
        return ret;
    }

    @Override
    public boolean hasAttribute(@Nullable String sAttrName) {
        return this.m_aAttrs != null && this.m_aAttrs.containsKey(sAttrName);
    }

    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable String sAttrName) {
        return EChange.valueOf(this.m_aAttrs != null && this.m_aAttrs.remove(sAttrName) != null);
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nonnull @Nonempty String sAttrName, @Nullable String sAttrValue) {
        if (StringHelper.hasNoText(sAttrName)) {
            throw new IllegalArgumentException("No valid attribute name passed");
        }
        if (GlobalDebug.isDebugMode() && !CXMLRegEx.PATTERN_NAME.matcher(sAttrName).matches()) {
            throw new IllegalArgumentException("The passed attribute name '" + sAttrName + "' is not a valid attribute name!");
        }
        if (sAttrValue != null) {
            if (this.m_aAttrs == null) {
                this.m_aAttrs = new LinkedHashMap<String, String>();
            }
            this.m_aAttrs.put(sAttrName, sAttrValue);
        } else {
            this.removeAttribute(sAttrName);
        }
        return this;
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nonnull String sAttrName, int nAttrValue) {
        return this.setAttribute(sAttrName, Integer.toString(nAttrValue));
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nonnull String sAttrName, long nAttrValue) {
        return this.setAttribute(sAttrName, Long.toString(nAttrValue));
    }

    @Override
    @Nonnull
    public IMicroElement setAttributeWithConversion(@Nonnull String sAttrName, @Nullable Object aAttrValue) {
        String sValue = TypeConverter.convertIfNecessary(aAttrValue, String.class);
        return this.setAttribute(sAttrName, sValue);
    }

    @Override
    @Nonnull
    public EChange removeAllAttributes() {
        if (ContainerHelper.isEmpty(this.m_aAttrs)) {
            return EChange.UNCHANGED;
        }
        this.m_aAttrs.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    public boolean hasNamespaceURI(@Nullable String sNamespaceURI) {
        return EqualsUtils.equals(this.m_sNamespaceURI, sNamespaceURI);
    }

    @Override
    @Nonnull
    public EChange setNamespaceURI(@Nullable String sNamespaceURI) {
        if (EqualsUtils.equals(this.m_sNamespaceURI, sNamespaceURI)) {
            return EChange.UNCHANGED;
        }
        this.m_sNamespaceURI = sNamespaceURI;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getLocalName() {
        return this.m_sNamespaceURI == null ? null : this.m_sTagName;
    }

    @Override
    @Nonnull
    public String getTagName() {
        return this.m_sTagName;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getChildElements() {
        ArrayList<IMicroElement> ret = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (aChild.isElement()) {
                    ret.add((IMicroElement)aChild);
                    continue;
                }
                if (!aChild.isContainer() || !aChild.hasChildren()) continue;
                for (IMicroNode aContChild : aChild.getChildren()) {
                    if (!aContChild.isElement()) continue;
                    ret.add((IMicroElement)aContChild);
                }
            }
        }
        return ret;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getChildElements(@Nullable String sTagName) {
        ArrayList<IMicroElement> ret = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (aChild.isElement()) {
                    IMicroElement aChildElement = (IMicroElement)aChild;
                    if (!aChildElement.getTagName().equals(sTagName)) continue;
                    ret.add(aChildElement);
                    continue;
                }
                if (!aChild.isContainer() || !aChild.hasChildren()) continue;
                for (IMicroNode aContChild : aChild.getChildren()) {
                    IMicroElement aContChildElement;
                    if (!aContChild.isElement() || !(aContChildElement = (IMicroElement)aContChild).getTagName().equals(sTagName)) continue;
                    ret.add(aContChildElement);
                }
            }
        }
        return ret;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getChildElements(@Nullable String sNamespaceURI, @Nullable String sLocalName) {
        if (StringHelper.hasNoText(sNamespaceURI)) {
            return this.getChildElements(sLocalName);
        }
        ArrayList<IMicroElement> ret = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (aChild.isElement()) {
                    IMicroElement aChildElement = (IMicroElement)aChild;
                    if (!aChildElement.hasNamespaceURI(sNamespaceURI) || !aChildElement.getLocalName().equals(sLocalName)) continue;
                    ret.add(aChildElement);
                    continue;
                }
                if (!aChild.isContainer() || !aChild.hasChildren()) continue;
                for (IMicroNode aContChild : aChild.getChildren()) {
                    IMicroElement aContChildElement;
                    if (!aContChild.isElement() || !(aContChildElement = (IMicroElement)aContChild).hasNamespaceURI(sNamespaceURI) || !aContChildElement.getLocalName().equals(sLocalName)) continue;
                    ret.add(aContChildElement);
                }
            }
        }
        return ret;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllChildElementsRecursive() {
        ArrayList<IMicroElement> ret = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (aChild.isElement()) {
                    IMicroElement aChildElement = (IMicroElement)aChild;
                    ret.add(aChildElement);
                    ret.addAll(aChildElement.getAllChildElementsRecursive());
                    continue;
                }
                if (!aChild.isContainer() || !aChild.hasChildren()) continue;
                for (IMicroNode aContChild : aChild.getChildren()) {
                    if (!aContChild.isElement()) continue;
                    MicroElement aContChildElement = (MicroElement)aContChild;
                    ret.add(aContChildElement);
                    ret.addAll(aContChildElement.getAllChildElementsRecursive());
                }
            }
        }
        return ret;
    }

    @Override
    public boolean hasChildElements() {
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (aChild.isElement()) {
                    return true;
                }
                if (!aChild.isContainer() || !aChild.hasChildren()) continue;
                for (IMicroNode aContChild : aChild.getChildren()) {
                    if (!aContChild.isElement()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasChildElements(@Nullable String sTagName) {
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (aChild.isElement()) {
                    if (!((IMicroElement)aChild).getTagName().equals(sTagName)) continue;
                    return true;
                }
                if (!aChild.isContainer() || !aChild.hasChildren()) continue;
                for (IMicroNode aContChild : aChild.getChildren()) {
                    if (!aContChild.isElement() || !((IMicroElement)aContChild).getTagName().equals(sTagName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasChildElements(@Nullable String sNamespaceURI, @Nullable String sLocalName) {
        if (StringHelper.hasNoText(sNamespaceURI)) {
            return this.hasChildElements(sLocalName);
        }
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (aChild.isElement()) {
                    IMicroElement aChildElement = (IMicroElement)aChild;
                    if (!aChildElement.hasNamespaceURI(sNamespaceURI) || !aChildElement.getLocalName().equals(sLocalName)) continue;
                    return true;
                }
                if (!aChild.isContainer() || !aChild.hasChildren()) continue;
                for (IMicroNode aContChild : aChild.getChildren()) {
                    IMicroElement aContChildElement;
                    if (!aContChild.isElement() || !(aContChildElement = (IMicroElement)aContChild).hasNamespaceURI(sNamespaceURI) || !aContChildElement.getLocalName().equals(sLocalName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement() {
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (aChild.isElement()) {
                    return (IMicroElement)aChild;
                }
                if (!aChild.isContainer() || !aChild.hasChildren()) continue;
                for (IMicroNode aContChild : aChild.getChildren()) {
                    if (!aContChild.isElement()) continue;
                    return (IMicroElement)aContChild;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement(@Nullable String sTagName) {
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (aChild.isElement()) {
                    IMicroElement aChildElement = (IMicroElement)aChild;
                    if (!aChildElement.getTagName().equals(sTagName)) continue;
                    return aChildElement;
                }
                if (!aChild.isContainer() || !aChild.hasChildren()) continue;
                for (IMicroNode aContChild : aChild.getChildren()) {
                    IMicroElement aContChildElement;
                    if (!aContChild.isElement() || !(aContChildElement = (IMicroElement)aContChild).getTagName().equals(sTagName)) continue;
                    return aContChildElement;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement(@Nullable String sNamespaceURI, @Nullable String sLocalName) {
        if (StringHelper.hasNoText(sNamespaceURI)) {
            return this.getFirstChildElement(sLocalName);
        }
        if (this.hasChildren()) {
            for (IMicroNode aChild : this.directGetChildren()) {
                if (aChild.isElement()) {
                    IMicroElement aChildElement = (IMicroElement)aChild;
                    if (!aChildElement.hasNamespaceURI(sNamespaceURI) || !aChildElement.getLocalName().equals(sLocalName)) continue;
                    return aChildElement;
                }
                if (!aChild.isContainer() || !aChild.hasChildren()) continue;
                for (IMicroNode aContChild : aChild.getChildren()) {
                    IMicroElement aContChildElement;
                    if (!aContChild.isElement() || !(aContChildElement = (IMicroElement)aContChild).hasNamespaceURI(sNamespaceURI) || !aContChildElement.getLocalName().equals(sLocalName)) continue;
                    return aContChildElement;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getTextContent() {
        if (!this.hasChildren()) {
            return null;
        }
        StringBuilder aSB = new StringBuilder();
        for (IMicroNode aChild : this.directGetChildren()) {
            if (aChild.isText()) {
                if (((IMicroText)aChild).isElementContentWhitespace()) continue;
                aSB.append(aChild.getNodeValue());
                continue;
            }
            if (aChild.isCDATA()) {
                aSB.append(aChild.getNodeValue());
                continue;
            }
            if (!aChild.isContainer() || !aChild.hasChildren()) continue;
            for (IMicroNode aContChild : aChild.getChildren()) {
                if (aContChild.isText()) {
                    if (((IMicroText)aContChild).isElementContentWhitespace()) continue;
                    aSB.append(aContChild.getNodeValue());
                    continue;
                }
                if (!aContChild.isCDATA()) continue;
                aSB.append(aContChild.getNodeValue());
            }
        }
        return aSB.toString();
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE getTextContentWithConversion(@Nonnull Class<DSTTYPE> aDstClass) {
        String sTextContent = this.getTextContent();
        if (StringHelper.hasNoText(sTextContent)) {
            return null;
        }
        DSTTYPE ret = TypeConverter.convertIfNecessary(sTextContent, aDstClass);
        return ret;
    }

    @Override
    @Nonnull
    public IMicroElement getClone() {
        MicroElement ret = new MicroElement(this.m_sNamespaceURI, this.m_sTagName);
        if (this.m_aAttrs != null) {
            ret.m_aAttrs = ContainerHelper.newOrderedMap(this.m_aAttrs);
        }
        if (this.hasChildren()) {
            for (IMicroNode aChildNode : this.directGetChildren()) {
                ret.appendChild((IMicroNode)aChildNode.getClone());
            }
        }
        return ret;
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode o) {
        if (o == this) {
            return true;
        }
        if (!super.isEqualContent(o)) {
            return false;
        }
        MicroElement rhs = (MicroElement)o;
        return EqualsUtils.equals(this.m_sNamespaceURI, rhs.m_sNamespaceURI) && this.m_sTagName.equals(rhs.m_sTagName) && EqualsUtils.equals(this.m_aAttrs, rhs.m_aAttrs);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).appendIfNotNull("namespace", this.m_sNamespaceURI).append("tagname", this.m_sTagName).appendIfNotNull("attrs", this.m_aAttrs).toString();
    }
}

