/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.convert.impl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.convert.IMicroTypeConverter;
import com.phloc.commons.microdom.convert.impl.StringMicroTypeConverter;
import com.phloc.commons.typeconvert.TypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class StringBasedMicroTypeConverter
implements IMicroTypeConverter {
    private final Class<?> m_aNativeClass;

    public StringBasedMicroTypeConverter(@Nonnull Class<?> aNativeClass) {
        if (aNativeClass == null) {
            throw new NullPointerException("nativeClass");
        }
        this.m_aNativeClass = aNativeClass;
    }

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull Object aObject, @Nullable String sNamespaceURI, @Nonnull @Nonempty String sTagName) {
        String sValue = TypeConverter.convertIfNecessary(aObject, String.class);
        return StringMicroTypeConverter.getInstance().convertToMicroElement(sValue, sNamespaceURI, sTagName);
    }

    @Override
    @Nonnull
    public Object convertToNative(@Nonnull IMicroElement aElement) {
        String sValue = StringMicroTypeConverter.getInstance().convertToNative(aElement);
        return TypeConverter.convertIfNecessary(sValue, this.m_aNativeClass);
    }
}

