/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.convert;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.lang.ClassHierarchyCache;
import com.phloc.commons.lang.ServiceLoaderBackport;
import com.phloc.commons.microdom.convert.IMicroTypeConverter;
import com.phloc.commons.microdom.convert.IMicroTypeConverterCallback;
import com.phloc.commons.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.phloc.commons.microdom.convert.IMicroTypeConverterRegistry;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MicroTypeConverterRegistry
implements IMicroTypeConverterRegistry {
    private static final MicroTypeConverterRegistry s_aInstance = new MicroTypeConverterRegistry();
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroTypeConverterRegistry.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<Class<?>, IMicroTypeConverter> s_aMap = new WeakHashMap();

    private MicroTypeConverterRegistry() {
    }

    @Override
    public void registerMicroElementTypeConverter(@Nonnull Class<?> aClass, @Nonnull IMicroTypeConverter aConverter) {
        MicroTypeConverterRegistry._registerMicroElementTypeConverter(aClass, aConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _registerMicroElementTypeConverter(@Nonnull Class<?> aClass, @Nonnull IMicroTypeConverter aConverter) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        if (aConverter == null) {
            throw new NullPointerException("converter");
        }
        s_aRWLock.writeLock().lock();
        try {
            if (s_aMap.containsKey(aClass)) {
                throw new IllegalArgumentException("A microtype convert for class " + aClass + " is already registered!");
            }
            for (WeakReference<Class<?>> aCurWRSrcClass : ClassHierarchyCache.getClassHierarchyIterator(aClass)) {
                Class aCurSrcClass = (Class)aCurWRSrcClass.get();
                if (aCurSrcClass == null || s_aMap.containsKey(aCurSrcClass)) continue;
                s_aMap.put(aCurSrcClass, aConverter);
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMicroTypeConverter getConverterToMicroElement(@Nullable Class<?> aSrcClass) {
        s_aRWLock.readLock().lock();
        try {
            IMicroTypeConverter iMicroTypeConverter = s_aMap.get(aSrcClass);
            return iMicroTypeConverter;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMicroTypeConverter getConverterToNative(@Nonnull Class<?> aDstClass) {
        if (aDstClass == null) {
            throw new NullPointerException("dstClass");
        }
        s_aRWLock.readLock().lock();
        try {
            IMicroTypeConverter ret = s_aMap.get(aDstClass);
            if (ret == null) {
                WeakReference<Class<?>> aCurWRDstClass;
                Class aCurDstClass;
                Iterator<WeakReference<Class<?>>> i$ = ClassHierarchyCache.getClassHierarchyIterator(aDstClass).iterator();
                while (i$.hasNext() && ((aCurDstClass = (Class)(aCurWRDstClass = i$.next()).get()) == null || (ret = s_aMap.get(aCurDstClass)) == null)) {
                }
            }
            IMicroTypeConverter iMicroTypeConverter = ret;
            return iMicroTypeConverter;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterateAllRegisteredMicroTypeConverters(@Nonnull IMicroTypeConverterCallback aCallback) {
        Map<Class<?>, IMicroTypeConverter> aCopy;
        s_aRWLock.readLock().lock();
        try {
            aCopy = ContainerHelper.newMap(s_aMap);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        for (Map.Entry<Class<?>, IMicroTypeConverter> aEntry : aCopy.entrySet()) {
            if (aCallback.call(aEntry.getKey(), aEntry.getValue()).isBreak()) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public static int getRegisteredMicroTypeConverterCount() {
        s_aRWLock.readLock().lock();
        try {
            int n = s_aMap.size();
            return n;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        for (IMicroTypeConverterRegistrarSPI aSPI : ServiceLoaderBackport.load(IMicroTypeConverterRegistrarSPI.class)) {
            aSPI.registerMicroTypeConverter(s_aInstance);
        }
        s_aLogger.info(MicroTypeConverterRegistry.getRegisteredMicroTypeConverterCount() + " micro type converters registered");
    }
}

