/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.messagedigest;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.messagedigest.EMessageDigestAlgorithm;
import com.phloc.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.phloc.commons.string.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MessageDigestGeneratorHelper {
    private static final MessageDigestGeneratorHelper s_aInstance = new MessageDigestGeneratorHelper();

    private MessageDigestGeneratorHelper() {
    }

    public static long getLongFromDigest(@Nonnull byte[] aDigest) {
        long nDigest = 0L;
        for (int i = 0; i < aDigest.length; i += 2) {
            nDigest += (long)((byte)(aDigest[i] << 8) | aDigest[i + 1]);
        }
        return nDigest;
    }

    @Nonnull
    public static String getHexValueFromDigest(@Nonnull byte[] aDigest) {
        return StringHelper.getHexEncoded(aDigest);
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull EMessageDigestAlgorithm eAlgorithm, @Nonnull String sText, @Nonnull @Nonempty String sCharset) {
        return MessageDigestGeneratorHelper.getDigest(sText, sCharset, eAlgorithm);
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull EMessageDigestAlgorithm eAlgorithm, @Nonnull String sText, @Nonnull Charset aCharset) {
        return MessageDigestGeneratorHelper.getDigest(sText, aCharset, eAlgorithm);
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull EMessageDigestAlgorithm eAlgorithm, @Nonnull byte[] aBytes) {
        return MessageDigestGeneratorHelper.getDigest(aBytes, eAlgorithm);
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull EMessageDigestAlgorithm eAlgorithm, @Nonnull byte[] aBytes, @Nonnegative int nOfs, @Nonnegative int nLength) {
        return MessageDigestGeneratorHelper.getDigest(aBytes, nOfs, nLength, eAlgorithm);
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull String sContent, @Nonnull @Nonempty String sCharset, EMessageDigestAlgorithm ... aAlgorithms) {
        return new NonBlockingMessageDigestGenerator(aAlgorithms).update(sContent, sCharset).getDigest();
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull String sContent, @Nonnull Charset aCharset, EMessageDigestAlgorithm ... aAlgorithms) {
        return new NonBlockingMessageDigestGenerator(aAlgorithms).update(sContent, aCharset).getDigest();
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull byte[] aContent, EMessageDigestAlgorithm ... aAlgorithms) {
        return new NonBlockingMessageDigestGenerator(aAlgorithms).update(aContent).getDigest();
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull byte[] aContent, @Nonnegative int nOfs, @Nonnegative int nLength, EMessageDigestAlgorithm ... aAlgorithms) {
        return new NonBlockingMessageDigestGenerator(aAlgorithms).update(aContent, nOfs, nLength).getDigest();
    }

    @Nonnull
    public static byte[] getDigestFromInputStream(@Nonnull @WillClose InputStream aIS, EMessageDigestAlgorithm ... aAlgorithms) {
        if (aIS == null) {
            throw new NullPointerException("inputStream");
        }
        NonBlockingMessageDigestGenerator aMDGen = new NonBlockingMessageDigestGenerator(aAlgorithms);
        byte[] aBuf = new byte[2048];
        try {
            int nBytesRead;
            while ((nBytesRead = aIS.read(aBuf)) > -1) {
                aMDGen.update(aBuf, 0, nBytesRead);
            }
            byte[] byArray = aMDGen.getDigest();
            return byArray;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read from InputStream for hashing!", ex);
        }
        finally {
            StreamUtils.close(aIS);
        }
    }
}

