/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.math;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.callback.INonThrowingRunnableWithParameter;
import com.phloc.commons.math.CombinationGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CombinationGeneratorFlexible<DATATYPE> {
    private final boolean m_bAllowEmpty;
    private final int m_nSlotCount;

    public CombinationGeneratorFlexible(@Nonnegative int nSlotCount, boolean bAllowEmpty) {
        if (nSlotCount < 0) {
            throw new IllegalArgumentException("Passed slot count is too small: " + nSlotCount);
        }
        this.m_nSlotCount = nSlotCount;
        this.m_bAllowEmpty = bAllowEmpty;
    }

    public void iterateAllCombinations(@Nonnull List<DATATYPE> aElements, @Nonnull INonThrowingRunnableWithParameter<List<DATATYPE>> aCallback) {
        int nSlotCount;
        if (aElements == null) {
            throw new NullPointerException("elements");
        }
        if (aCallback == null) {
            throw new NullPointerException("callback");
        }
        int n = nSlotCount = this.m_bAllowEmpty ? 0 : 1;
        while (nSlotCount <= this.m_nSlotCount) {
            if (aElements.isEmpty()) {
                aCallback.run(new ArrayList());
            } else {
                for (List<DATATYPE> aPermutation : new CombinationGenerator<DATATYPE>(aElements, nSlotCount)) {
                    aCallback.run(aPermutation);
                }
            }
            ++nSlotCount;
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<List<DATATYPE>> getCombinations(@Nonnull List<DATATYPE> aElements) {
        if (aElements == null) {
            throw new NullPointerException("elements");
        }
        final HashSet<List<DATATYPE>> aAllResults = new HashSet<List<DATATYPE>>();
        this.iterateAllCombinations(aElements, new INonThrowingRunnableWithParameter<List<DATATYPE>>(){

            @Override
            public void run(List<DATATYPE> aCurrentObject) {
                aAllResults.add(aCurrentObject);
            }
        });
        return aAllResults;
    }

    public static <DATATYPE> void iterateAllCombinations(@Nonnull List<DATATYPE> aElements, boolean bAllowEmpty, @Nonnull INonThrowingRunnableWithParameter<List<DATATYPE>> aCallback) {
        new CombinationGeneratorFlexible<DATATYPE>(aElements.size(), bAllowEmpty).iterateAllCombinations(aElements, aCallback);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <DATATYPE> Set<List<DATATYPE>> getCombinations(@Nonnull List<DATATYPE> aElements, boolean bAllowEmpty) {
        return new CombinationGeneratorFlexible<DATATYPE>(aElements.size(), bAllowEmpty).getCombinations(aElements);
    }
}

