/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.math;

import com.phloc.commons.CGlobal;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.math.FactorialHelper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CombinationGenerator<DATATYPE>
implements IIterableIterator<List<DATATYPE>> {
    private final Object[] m_aElements;
    private final int[] m_aIndexResult;
    private final BigInteger m_aTotalCombinations;
    private BigInteger m_aCombinationsLeft;
    private final boolean m_bUseLong;
    private final long m_nTotalCombinations;
    private long m_nCombinationsLeft;

    public CombinationGenerator(@Nonnull @Nonempty List<DATATYPE> aElements, @Nonnegative int nSlotCount) {
        if (ContainerHelper.isEmpty(aElements)) {
            throw new IllegalArgumentException("No elements passed");
        }
        if (nSlotCount < 0) {
            throw new IllegalArgumentException("To small slot count: " + nSlotCount);
        }
        if (nSlotCount > aElements.size()) {
            throw new IllegalArgumentException("To few elements for specified slots: " + aElements.size());
        }
        this.m_aElements = aElements.toArray();
        this.m_aIndexResult = new int[nSlotCount];
        BigInteger aElementFactorial = FactorialHelper.getAnyFactorialLinear(this.m_aElements.length);
        BigInteger aSlotFactorial = FactorialHelper.getAnyFactorialLinear(nSlotCount);
        BigInteger aOverflowFactorial = FactorialHelper.getAnyFactorialLinear(this.m_aElements.length - nSlotCount);
        this.m_aTotalCombinations = aElementFactorial.divide(aSlotFactorial.multiply(aOverflowFactorial));
        this.m_bUseLong = this.m_aTotalCombinations.compareTo(CGlobal.BIGINT_MAX_LONG) < 0;
        this.m_nTotalCombinations = this.m_bUseLong ? this.m_aTotalCombinations.longValue() : -1L;
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.m_aIndexResult.length; ++i) {
            this.m_aIndexResult[i] = i;
        }
        this.m_aCombinationsLeft = this.m_aTotalCombinations;
        this.m_nCombinationsLeft = this.m_nTotalCombinations;
    }

    @Nonnull
    public BigInteger getCombinationsLeft() {
        return this.m_bUseLong ? BigInteger.valueOf(this.m_nCombinationsLeft) : this.m_aCombinationsLeft;
    }

    @Override
    public boolean hasNext() {
        return this.m_bUseLong ? this.m_nCombinationsLeft > 0L : this.m_aCombinationsLeft.compareTo(BigInteger.ZERO) > 0;
    }

    @Nonnull
    public BigInteger getTotalCombinations() {
        return this.m_aTotalCombinations;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<DATATYPE> next() {
        boolean bFirstItem;
        boolean bl = this.m_bUseLong ? this.m_nCombinationsLeft == this.m_nTotalCombinations : (bFirstItem = this.m_aCombinationsLeft.equals(this.m_aTotalCombinations));
        if (!bFirstItem) {
            int nElementCount = this.m_aElements.length;
            int nSlotCount = this.m_aIndexResult.length;
            int i = nSlotCount - 1;
            while (this.m_aIndexResult[i] == nElementCount - nSlotCount + i) {
                --i;
            }
            int n = i;
            this.m_aIndexResult[n] = this.m_aIndexResult[n] + 1;
            for (int j = i + 1; j < nSlotCount; ++j) {
                this.m_aIndexResult[j] = this.m_aIndexResult[i] + j - i;
            }
        }
        if (this.m_bUseLong) {
            --this.m_nCombinationsLeft;
        } else {
            this.m_aCombinationsLeft = this.m_aCombinationsLeft.subtract(BigInteger.ONE);
        }
        ArrayList aResult = new ArrayList(this.m_aIndexResult.length);
        for (int nIndex : this.m_aIndexResult) {
            aResult.add(GenericReflection.uncheckedCast(this.m_aElements[nIndex]));
        }
        return aResult;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<List<DATATYPE>> iterator() {
        return this;
    }

    @Nonnull
    public static <DATATYPE> List<List<DATATYPE>> getAllPermutations(@Nonnull @Nonempty List<DATATYPE> aInput, @Nonnegative int nSlotCount) {
        ArrayList<List<DATATYPE>> aResultList = new ArrayList<List<DATATYPE>>();
        CombinationGenerator.addAllPermutations(aInput, nSlotCount, aResultList);
        return aResultList;
    }

    public static <DATATYPE> void addAllPermutations(@Nonnull @Nonempty List<DATATYPE> aInput, @Nonnegative int nSlotCount, @Nonnull Collection<List<DATATYPE>> aResultList) {
        for (List<DATATYPE> aPermutation : new CombinationGenerator<DATATYPE>(aInput, nSlotCount)) {
            aResultList.add(aPermutation);
        }
    }
}

