/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.log;

import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IHasErrorLevel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class LogUtils {
    private static final LogUtils s_aInstance = new LogUtils();

    private LogUtils() {
    }

    public static boolean isEnabled(@Nonnull Class<?> aLoggingClass, @Nonnull IHasErrorLevel aErrorLevelProvider) {
        return LogUtils.isEnabled(LoggerFactory.getLogger(aLoggingClass), aErrorLevelProvider.getErrorLevel());
    }

    public static boolean isEnabled(@Nonnull Logger aLogger, @Nonnull IHasErrorLevel aErrorLevelProvider) {
        return LogUtils.isEnabled(aLogger, aErrorLevelProvider.getErrorLevel());
    }

    public static boolean isEnabled(@Nonnull Class<?> aLoggingClass, @Nonnull EErrorLevel eErrorLevel) {
        return LogUtils.isEnabled(LoggerFactory.getLogger(aLoggingClass), eErrorLevel);
    }

    public static boolean isEnabled(@Nonnull Logger aLogger, @Nonnull EErrorLevel eErrorLevel) {
        if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.ERROR)) {
            return aLogger.isErrorEnabled();
        }
        if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.WARN)) {
            return aLogger.isWarnEnabled();
        }
        if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.INFO)) {
            return aLogger.isInfoEnabled();
        }
        return aLogger.isDebugEnabled();
    }

    public static void log(@Nonnull Class<?> aLoggingClass, @Nonnull IHasErrorLevel aErrorLevelProvider, @Nonnull String sMsg) {
        LogUtils.log(aLoggingClass, aErrorLevelProvider.getErrorLevel(), sMsg, null);
    }

    public static void log(@Nonnull Class<?> aLoggingClass, @Nonnull IHasErrorLevel aErrorLevelProvider, @Nonnull String sMsg, @Nullable Throwable t) {
        LogUtils.log(LoggerFactory.getLogger(aLoggingClass), aErrorLevelProvider.getErrorLevel(), sMsg, t);
    }

    public static void log(@Nonnull Logger aLogger, @Nonnull IHasErrorLevel aErrorLevelProvider, @Nonnull String sMsg) {
        LogUtils.log(aLogger, aErrorLevelProvider.getErrorLevel(), sMsg, null);
    }

    public static void log(@Nonnull Logger aLogger, @Nonnull IHasErrorLevel aErrorLevelProvider, @Nonnull String sMsg, @Nullable Throwable t) {
        LogUtils.log(aLogger, aErrorLevelProvider.getErrorLevel(), sMsg, t);
    }

    public static void log(@Nonnull Class<?> aLoggingClass, @Nonnull EErrorLevel eErrorLevel, @Nonnull String sMsg) {
        LogUtils.log(aLoggingClass, eErrorLevel, sMsg, null);
    }

    public static void log(@Nonnull Class<?> aLoggingClass, @Nonnull EErrorLevel eErrorLevel, @Nonnull String sMsg, @Nullable Throwable t) {
        LogUtils.log(LoggerFactory.getLogger(aLoggingClass), eErrorLevel, sMsg, t);
    }

    public static void log(@Nonnull Logger aLogger, @Nonnull EErrorLevel eErrorLevel, @Nonnull String sMsg) {
        LogUtils.log(aLogger, eErrorLevel, sMsg, null);
    }

    public static void log(@Nonnull Logger aLogger, @Nonnull EErrorLevel eErrorLevel, @Nonnull String sMsg, @Nullable Throwable t) {
        if (aLogger == null) {
            throw new NullPointerException("logger");
        }
        if (eErrorLevel == null) {
            throw new NullPointerException("errorLevel");
        }
        if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.ERROR)) {
            aLogger.error(sMsg, t);
        } else if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.WARN)) {
            aLogger.warn(sMsg, t);
        } else if (eErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.INFO)) {
            aLogger.info(sMsg, t);
        } else if (aLogger.isDebugEnabled()) {
            aLogger.debug(sMsg, t);
        }
    }
}

