/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.ICloneable;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.GenericReflection;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CloneHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CloneHelper.class);
    private static final CloneHelper s_aInstance = new CloneHelper();

    private CloneHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static <DATATYPE> DATATYPE _getGenericClone(@Nonnull DATATYPE aObject) {
        if (aObject instanceof ICloneable) {
            return ((ICloneable)GenericReflection.uncheckedCast(aObject)).getClone();
        }
        try {
            try {
                return (DATATYPE)GenericReflection.invokeMethod(aObject, "clone", new Object[0]);
            }
            catch (Exception ex) {
                try {
                    s_aLogger.warn("Failed to invoke clone on " + aObject.getClass().getName());
                    Constructor<DATATYPE> aCtor = GenericReflection.findConstructor(aObject, aObject.getClass());
                    if (aCtor == null) return null;
                    return aCtor.newInstance(aObject);
                }
                catch (Exception ex2) {
                    s_aLogger.error("Failed to clone object of type '" + aObject.getClass().getName() + "' because it has neither a (visible) clone method nor a copy constructor.", (Throwable)ex2);
                    return null;
                }
            }
        }
        catch (IllegalAccessException ex) {
            s_aLogger.error("Failed to clone object of type '" + aObject.getClass().getName() + "' because it has neither a (visible) clone method nor a copy constructor or the methods are invisible.");
            return null;
        }
        catch (NoSuchMethodException ex) {
            s_aLogger.error("Failed to clone object of type '" + aObject.getClass().getName() + "' because it has neither a clone method nor a (visible) copy constructor or the methods are invisible.");
            return null;
        }
    }

    @Nullable
    public static <DATATYPE> DATATYPE getClonedValue(@Nullable DATATYPE aObject) {
        if (aObject == null) {
            return null;
        }
        Class<?> aClass = aObject.getClass();
        if (ClassHelper.isPrimitiveWrapperType(aClass) || aObject instanceof String || aClass.getAnnotation(Immutable.class) != null) {
            return aObject;
        }
        return CloneHelper._getGenericClone(aObject);
    }
}

