/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BitSetHelper {
    private static final BitSetHelper s_aInstance = new BitSetHelper();

    private BitSetHelper() {
    }

    @Nonnull
    public static BitSet createBitSet(byte nValue) {
        BitSet ret = new BitSet(8);
        for (int i = 0; i < 8; ++i) {
            ret.set(i, (nValue >> i & 1) == 1);
        }
        return ret;
    }

    @Nonnull
    public static BitSet createBitSet(short nValue) {
        BitSet ret = new BitSet(16);
        for (int i = 0; i < 16; ++i) {
            ret.set(i, (nValue >> i & 1) == 1);
        }
        return ret;
    }

    @Nonnull
    public static BitSet createBitSet(int nValue) {
        BitSet ret = new BitSet(32);
        for (int i = 0; i < 32; ++i) {
            ret.set(i, (nValue >> i & 1) == 1);
        }
        return ret;
    }

    @Nonnull
    public static BitSet createBitSet(long nValue) {
        BitSet ret = new BitSet(64);
        for (int i = 0; i < 64; ++i) {
            ret.set(i, (nValue >> i & 1L) == 1L);
        }
        return ret;
    }

    public static int getExtractedIntValue(@Nonnull BitSet aBS) {
        if (aBS == null) {
            throw new NullPointerException("bitSet");
        }
        int nMax = aBS.length();
        if (nMax > 32) {
            throw new IllegalArgumentException("Can extract only up to 32 bits");
        }
        int ret = 0;
        for (int i = nMax - 1; i >= 0; --i) {
            ret <<= 1;
            if (!aBS.get(i)) continue;
            ++ret;
        }
        return ret;
    }

    public static long getExtractedLongValue(@Nonnull BitSet aBS) {
        if (aBS == null) {
            throw new NullPointerException("bitSet");
        }
        int nMax = aBS.length();
        if (nMax > 64) {
            throw new IllegalArgumentException("Can extract only up to 64 bits");
        }
        long ret = 0L;
        for (int i = nMax - 1; i >= 0; --i) {
            ret <<= 1;
            if (!aBS.get(i)) continue;
            ++ret;
        }
        return ret;
    }
}

