/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.jmx;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.exceptions.LoggedRuntimeException;
import com.phloc.commons.lang.CGStringHelper;
import com.phloc.commons.string.StringHelper;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.management.JMException;
import javax.management.ObjectName;

@Immutable
public final class ObjectNameUtils {
    private static final ObjectNameUtils s_aInstance = new ObjectNameUtils();
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static String s_sDefaultJMXDomain = "com.phloc";

    private ObjectNameUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultJMXDomain(@Nonnull @Nonempty String sDefaultJMXDomain) {
        if (StringHelper.hasNoText(sDefaultJMXDomain)) {
            throw new IllegalArgumentException("defaultJMXDomain is empty");
        }
        if (sDefaultJMXDomain.indexOf(58) >= 0 || sDefaultJMXDomain.indexOf(32) >= 0) {
            throw new IllegalArgumentException("defaultJMXDomain contains invalid chars: " + sDefaultJMXDomain);
        }
        s_aRWLock.writeLock().lock();
        try {
            s_sDefaultJMXDomain = sDefaultJMXDomain;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Nonempty
    public static String getDefaultJMXDomain() {
        s_aRWLock.readLock().lock();
        try {
            String string = s_sDefaultJMXDomain;
            return string;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    public static ObjectName create(@Nonnull @Nonempty Hashtable<String, String> aParams) {
        if (ContainerHelper.isEmpty(aParams)) {
            throw new IllegalArgumentException("JMX objectName parameters may not be empty!");
        }
        try {
            return new ObjectName(ObjectNameUtils.getDefaultJMXDomain(), aParams);
        }
        catch (JMException ex) {
            throw LoggedRuntimeException.newException("Failed to create ObjectName with parameter " + aParams, ex);
        }
    }

    @Nonnull
    public static ObjectName create(@Nonnull @Nonempty Map<String, String> aParams) {
        if (ContainerHelper.isEmpty(aParams)) {
            throw new IllegalArgumentException("JMX objectName parameters may not be empty!");
        }
        return ObjectNameUtils.create(new Hashtable<String, String>(aParams));
    }

    @Nonnull
    public static String getCleanPropertyValue(@Nonnull String sPropertyValue) {
        if (sPropertyValue.indexOf(32) != -1) {
            return ObjectName.quote(sPropertyValue);
        }
        return sPropertyValue.replace(':', '.').replace(',', '.').replace("//", "__");
    }

    @Nonnull
    public static ObjectName createWithDefaultProperties(@Nonnull Object aObj) {
        if (aObj == null) {
            throw new NullPointerException("object");
        }
        Hashtable<String, String> aParams = new Hashtable<String, String>();
        aParams.put("type", CGStringHelper.getClassLocalName(aObj));
        return ObjectNameUtils.create(aParams);
    }

    @Nonnull
    public static ObjectName createWithDefaultProperties(@Nonnull Object aObj, @Nonnull String sName) {
        if (aObj == null) {
            throw new NullPointerException("object");
        }
        if (sName == null) {
            throw new NullPointerException("name");
        }
        Hashtable<String, String> aParams = new Hashtable<String, String>();
        aParams.put("type", CGStringHelper.getClassLocalName(aObj));
        aParams.put("name", ObjectNameUtils.getCleanPropertyValue(sName));
        return ObjectNameUtils.create(aParams);
    }
}

