/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resourceprovider;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IReadableResourceProvider;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassPathResourceProvider
implements IReadableResourceProvider {
    private final String m_sPrefix;

    public ClassPathResourceProvider() {
        this(null);
    }

    public ClassPathResourceProvider(@Nullable String sPrefix) {
        this.m_sPrefix = sPrefix;
    }

    @Override
    public boolean supportsReading(@Nullable String sName) {
        return StringHelper.hasText(sName);
    }

    @Override
    @Nonnull
    public IReadableResource getReadableResource(@Nonnull String sName) {
        if (sName == null) {
            throw new NullPointerException("name");
        }
        return new ClassPathResource(this.m_sPrefix == null ? sName : this.m_sPrefix + sName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassPathResourceProvider)) {
            return false;
        }
        ClassPathResourceProvider rhs = (ClassPathResourceProvider)o;
        return EqualsUtils.equals(this.m_sPrefix, rhs.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("prefix", this.m_sPrefix).toString();
    }
}

