/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resource;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassPathResource
implements IReadableResource {
    private static final long serialVersionUID = 8864321231897321L;
    public static final String CLASSPATH_PREFIX_LONG = "classpath:";
    public static final String CLASSPATH_PREFIX_SHORT = "cp:";
    private final String m_sPath;
    private final transient WeakReference<ClassLoader> m_aClassLoader;
    private boolean m_bURLResolved = false;
    private URL m_aURL;

    public ClassPathResource(@Nonnull URL aURL) {
        this(aURL, null);
    }

    public ClassPathResource(@Nonnull URL aURL, @Nullable ClassLoader aClassLoader) {
        this(aURL.toExternalForm(), aClassLoader);
    }

    public ClassPathResource(@Nonnull @Nonempty String sPath) {
        this(sPath, null);
    }

    public ClassPathResource(@Nonnull @Nonempty String sPath, @Nullable ClassLoader aClassLoader) {
        if (StringHelper.hasNoText(sPath)) {
            throw new IllegalArgumentException("No path specified");
        }
        this.m_sPath = StringHelper.startsWith((CharSequence)sPath, CLASSPATH_PREFIX_LONG) ? sPath.substring(CLASSPATH_PREFIX_LONG.length()) : (StringHelper.startsWith((CharSequence)sPath, CLASSPATH_PREFIX_SHORT) ? sPath.substring(CLASSPATH_PREFIX_SHORT.length()) : sPath);
        if (StringHelper.hasNoText(this.m_sPath)) {
            throw new IllegalArgumentException("No path specified after prefix: " + sPath);
        }
        this.m_aClassLoader = aClassLoader == null ? null : new WeakReference<ClassLoader>(aClassLoader);
    }

    public static boolean isExplicitClassPathResource(@Nullable String sName) {
        return StringHelper.startsWith((CharSequence)sName, CLASSPATH_PREFIX_LONG) || StringHelper.startsWith((CharSequence)sName, CLASSPATH_PREFIX_SHORT);
    }

    @Nullable
    private ClassLoader _getSpecifiedClassLoader() {
        return this.m_aClassLoader == null ? null : (ClassLoader)this.m_aClassLoader.get();
    }

    @Override
    @Nonnull
    public String getResourceID() {
        URL aURL = this.getAsURL();
        return aURL == null ? this.m_sPath : aURL.toExternalForm();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_sPath;
    }

    @Nullable
    private static InputStream _asInputStream(@Nullable URL aURL) {
        return aURL == null ? null : URLResource.getInputStream(aURL);
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull @Nonempty String sPath) {
        URL aURL = ClassPathResource.getAsURL(sPath);
        return ClassPathResource._asInputStream(aURL);
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull @Nonempty String sPath, @Nonnull ClassLoader aClassLoader) {
        URL aURL = ClassPathResource.getAsURL(sPath, aClassLoader);
        return ClassPathResource._asInputStream(aURL);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        URL aURL = this.getAsURL();
        return ClassPathResource._asInputStream(aURL);
    }

    @Nullable
    public InputStream getInputStreamNoCache(@Nonnull ClassLoader aClassLoader) {
        URL aURL = this.getAsURLNoCache(aClassLoader);
        return ClassPathResource._asInputStream(aURL);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull String sCharset) {
        return StreamUtils.createReader(this.getInputStream(), sCharset);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull Charset aCharset) {
        return StreamUtils.createReader(this.getInputStream(), aCharset);
    }

    @Nullable
    public Reader getReaderNoCache(@Nonnull ClassLoader aClassLoader, @Nonnull String sCharset) {
        return StreamUtils.createReader(this.getInputStreamNoCache(aClassLoader), sCharset);
    }

    @Override
    public boolean exists() {
        return this.getAsURL() != null;
    }

    public boolean existsNoCacheUsage() {
        return ClassPathResource.getAsURL(this.m_sPath) != null;
    }

    @Nullable
    public static URL getAsURL(@Nonnull @Nonempty String sPath) {
        if (StringHelper.hasNoText(sPath)) {
            throw new IllegalArgumentException("No path specified");
        }
        String sRealPath = sPath.startsWith("/") ? sPath : '/' + sPath;
        URL ret = ClassHelper.getDefaultClassLoader().getResource(sRealPath);
        if (ret == null && (ret = ClassPathResource.class.getResource(sRealPath)) == null) {
            ret = ClassLoader.getSystemClassLoader().getResource(sRealPath);
        }
        return ret;
    }

    @Nullable
    public static URL getAsURL(@Nonnull @Nonempty String sPath, @Nonnull ClassLoader aClassLoader) {
        if (aClassLoader == null) {
            throw new NullPointerException("classLoader");
        }
        if (StringHelper.hasNoText(sPath)) {
            throw new IllegalArgumentException("No path specified");
        }
        String sRealPath = sPath.startsWith("/") ? sPath : '/' + sPath;
        return aClassLoader.getResource(sRealPath);
    }

    @Override
    @Nullable
    public URL getAsURL() {
        if (!this.m_bURLResolved) {
            ClassLoader aClassLoader = this._getSpecifiedClassLoader();
            this.m_aURL = aClassLoader == null ? ClassPathResource.getAsURL(this.m_sPath) : ClassPathResource.getAsURL(this.m_sPath, aClassLoader);
            this.m_bURLResolved = true;
        }
        return this.m_aURL;
    }

    @Nullable
    public URL getAsURLNoCache(@Nonnull ClassLoader aClassLoader) {
        return ClassPathResource.getAsURL(this.m_sPath, aClassLoader);
    }

    @Nullable
    private static File _getAsFile(@Nullable URL aURL) {
        if (aURL != null) {
            try {
                return URLResource.getAsFile(aURL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static File getAsFile(@Nonnull @Nonempty String sPath) {
        URL aURL = ClassPathResource.getAsURL(sPath);
        return ClassPathResource._getAsFile(aURL);
    }

    @Nullable
    public static File getAsFile(@Nonnull @Nonempty String sPath, @Nonnull ClassLoader aClassLoader) {
        URL aURL = ClassPathResource.getAsURL(sPath, aClassLoader);
        return ClassPathResource._getAsFile(aURL);
    }

    @Override
    @Nullable
    public File getAsFile() {
        URL aURL = this.getAsURL();
        return ClassPathResource._getAsFile(aURL);
    }

    @Nullable
    public File getAsFileNoCache(@Nonnull ClassLoader aClassLoader) {
        URL aURL = this.getAsURLNoCache(aClassLoader);
        return ClassPathResource._getAsFile(aURL);
    }

    public static boolean canRead(@Nonnull @Nonempty String sPath) {
        return ClassPathResource.getAsURL(sPath) != null;
    }

    public static boolean canRead(@Nonnull @Nonempty String sPath, @Nonnull ClassLoader aClassLoader) {
        return ClassPathResource.getAsURL(sPath, aClassLoader) != null;
    }

    public boolean canRead() {
        return this.getAsURL() != null;
    }

    public boolean canReadNoCache(@Nonnull ClassLoader aClassLoader) {
        return this.getAsURLNoCache(aClassLoader) != null;
    }

    @Override
    @Nonnull
    public ClassPathResource getReadableCloneForPath(@Nonnull String sPath) {
        return new ClassPathResource(sPath, this._getSpecifiedClassLoader());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassPathResource)) {
            return false;
        }
        ClassPathResource rhs = (ClassPathResource)o;
        return EqualsUtils.equals(this.m_sPath, rhs.m_sPath) && EqualsUtils.equals(this._getSpecifiedClassLoader(), rhs._getSpecifiedClassLoader());
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPath).append(this.m_aClassLoader).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("cpPath", this.m_sPath).appendIfNotNull("classLoader", this._getSpecifiedClassLoader()).append("urlResolved", this.m_bURLResolved).append("URL", this.m_aURL).toString();
    }
}

