/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resolver;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.IInputStreamResolver;
import com.phloc.commons.io.IOutputStreamResolver;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FileSystemStreamResolver
implements IInputStreamResolver,
IOutputStreamResolver {
    private final File m_aBasePath;

    public FileSystemStreamResolver(@Nonnull String sBasePath) {
        this(new File(sBasePath));
    }

    public FileSystemStreamResolver(@Nonnull File aBasePath) {
        if (aBasePath == null) {
            throw new NullPointerException("basePath");
        }
        if (!aBasePath.exists()) {
            throw new IllegalArgumentException("Base path does not exist: " + aBasePath);
        }
        if (!aBasePath.isDirectory()) {
            throw new IllegalArgumentException("Only directories are allowed as base path: " + aBasePath);
        }
        this.m_aBasePath = aBasePath;
    }

    @Override
    @Nullable
    public InputStream getInputStream(@Nonnull String sName) {
        return FileUtils.getInputStream(new File(this.m_aBasePath, sName));
    }

    @Override
    @Nullable
    public OutputStream getOutputStream(@Nonnull String sName, @Nonnull EAppend eAppend) {
        return FileUtils.getOutputStream(new File(this.m_aBasePath, sName), eAppend);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSystemStreamResolver)) {
            return false;
        }
        FileSystemStreamResolver rhs = (FileSystemStreamResolver)o;
        return this.m_aBasePath.equals(rhs.m_aBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("basePath", this.m_aBasePath).toString();
    }
}

