/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.io.file.EFileIOOperation;
import com.phloc.commons.io.file.FileIOError;
import com.phloc.commons.state.ISuccessIndicator;
import java.io.File;
import javax.annotation.Nonnull;

public enum EFileIOErrorCode implements ISuccessIndicator
{
    NO_ERROR,
    OPERATION_FAILED,
    SECURITY_ERROR,
    SOURCE_DOES_NOT_EXIST,
    TARGET_ALREADY_EXISTS,
    SOURCE_EQUALS_TARGET,
    TARGET_IS_CHILD_OF_SOURCE,
    OBJECT_CANNOT_BE_HANDLED,
    OBJECT_HAS_NO_PARENT,
    SOURCE_NOT_READABLE,
    SOURCE_PARENT_NOT_WRITABLE,
    TARGET_PARENT_NOT_WRITABLE;


    @Nonnull
    public FileIOError getAsIOError(@Nonnull EFileIOOperation eOperation, @Nonnull File aFile) {
        return new FileIOError(eOperation, this, aFile);
    }

    @Nonnull
    public FileIOError getAsIOError(@Nonnull EFileIOOperation eOperation, @Nonnull File aFile1, @Nonnull File aFile2) {
        if (eOperation.getParamCount() < 2) {
            throw new IllegalStateException("The operation " + (Object)((Object)eOperation) + " expects only one parameter!");
        }
        return new FileIOError(eOperation, this, aFile1, aFile2);
    }

    @Override
    public boolean isSuccess() {
        return this == NO_ERROR;
    }

    @Override
    public boolean isFailure() {
        return this != NO_ERROR;
    }

    @Nonnull
    public static FileIOError getAsIOError(@Nonnull EFileIOOperation eOperation, @Nonnull SecurityException ex) {
        return new FileIOError(eOperation, SECURITY_ERROR, ex);
    }
}

