/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.hash;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.hash.HashCodeCalculator;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.hash.IHashCodeImplementation;
import com.phloc.commons.hash.IHashCodeImplementationRegistrarSPI;
import com.phloc.commons.hash.IHashCodeImplementationRegistry;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@IsSPIImplementation
public final class DefaultHashCodeImplementationRegistrarSPI
implements IHashCodeImplementationRegistrarSPI {
    @Override
    public void registerHashCodeImplementations(@Nonnull IHashCodeImplementationRegistry aRegistry) {
        aRegistry.registerHashCodeImplementation(StringBuffer.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                return aObj.toString().hashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(StringBuilder.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                return aObj.toString().hashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(Node.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                Node aRealObj = (Node)aObj;
                HashCodeGenerator aHC = new HashCodeGenerator(aRealObj).append(aRealObj.getNodeType()).append(aRealObj.getNodeName()).append(aRealObj.getLocalName()).append(aRealObj.getNamespaceURI()).append(aRealObj.getPrefix()).append(aRealObj.getNodeValue());
                NodeList aNL = aRealObj.getChildNodes();
                int nLength = aNL.getLength();
                aHC = aHC.append(nLength);
                for (int i = 0; i < nLength; ++i) {
                    aHC = aHC.append(aNL.item(i));
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(AtomicBoolean.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                return HashCodeCalculator.append(0, ((AtomicBoolean)aObj).get());
            }
        });
        aRegistry.registerHashCodeImplementation(AtomicInteger.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                return HashCodeCalculator.append(0, ((AtomicInteger)aObj).get());
            }
        });
        aRegistry.registerHashCodeImplementation(AtomicLong.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                return HashCodeCalculator.append(0, ((AtomicLong)aObj).get());
            }
        });
        aRegistry.registerHashCodeImplementation(boolean[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                boolean[] aArray = (boolean[])aObj;
                int nLength = aArray.length;
                HashCodeGenerator aHC = new HashCodeGenerator(aObj.getClass()).append(nLength);
                for (int i = 0; i < nLength; ++i) {
                    aHC = aHC.append(aArray[i]);
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(byte[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                byte[] aArray = (byte[])aObj;
                int nLength = aArray.length;
                HashCodeGenerator aHC = new HashCodeGenerator(aObj.getClass()).append(nLength);
                for (int i = 0; i < nLength; ++i) {
                    aHC = aHC.append(aArray[i]);
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(char[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                char[] aArray = (char[])aObj;
                int nLength = aArray.length;
                HashCodeGenerator aHC = new HashCodeGenerator(aObj.getClass()).append(nLength);
                for (int i = 0; i < nLength; ++i) {
                    aHC = aHC.append(aArray[i]);
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(double[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                double[] aArray = (double[])aObj;
                int nLength = aArray.length;
                HashCodeGenerator aHC = new HashCodeGenerator(aObj.getClass()).append(nLength);
                for (int i = 0; i < nLength; ++i) {
                    aHC = aHC.append(aArray[i]);
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(float[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                float[] aArray = (float[])aObj;
                int nLength = aArray.length;
                HashCodeGenerator aHC = new HashCodeGenerator(aObj.getClass()).append(nLength);
                for (int i = 0; i < nLength; ++i) {
                    aHC = aHC.append(aArray[i]);
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(int[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                int[] aArray = (int[])aObj;
                int nLength = aArray.length;
                HashCodeGenerator aHC = new HashCodeGenerator(aObj.getClass()).append(nLength);
                for (int i = 0; i < nLength; ++i) {
                    aHC = aHC.append(aArray[i]);
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(long[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                long[] aArray = (long[])aObj;
                int nLength = aArray.length;
                HashCodeGenerator aHC = new HashCodeGenerator(aObj.getClass()).append(nLength);
                for (int i = 0; i < nLength; ++i) {
                    aHC = aHC.append(aArray[i]);
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(short[].class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                short[] aArray = (short[])aObj;
                int nLength = aArray.length;
                HashCodeGenerator aHC = new HashCodeGenerator(aObj.getClass()).append(nLength);
                for (int i = 0; i < nLength; ++i) {
                    aHC = aHC.append(aArray[i]);
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(Map.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                Map aRealObj = (Map)aObj;
                HashCodeGenerator aHC = new HashCodeGenerator(aRealObj).append(aRealObj.size());
                for (Map.Entry aEntry : aRealObj.entrySet()) {
                    aHC = aHC.append(aEntry.getKey()).append(aEntry.getValue());
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(Collection.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                Collection aRealObj = (Collection)aObj;
                HashCodeGenerator aHC = new HashCodeGenerator(aRealObj).append(aRealObj.size());
                for (Object aMember : aRealObj) {
                    aHC = aHC.append(aMember);
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(Iterator.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                Iterator aRealObj = (Iterator)aObj;
                HashCodeGenerator aHC = new HashCodeGenerator(aRealObj);
                while (aRealObj.hasNext()) {
                    aHC = aHC.append(aRealObj.next());
                }
                return aHC.getHashCode();
            }
        });
        aRegistry.registerHashCodeImplementation(Enumeration.class, new IHashCodeImplementation(){

            @Override
            public int getHashCode(Object aObj) {
                Enumeration aRealObj = (Enumeration)aObj;
                HashCodeGenerator aHC = new HashCodeGenerator(aRealObj);
                while (aRealObj.hasMoreElements()) {
                    aHC = aHC.append(aRealObj.nextElement());
                }
                return aHC.getHashCode();
            }
        });
    }
}

