/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.graph.impl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.graph.IGraphNode;
import com.phloc.commons.graph.IGraphRelation;
import com.phloc.commons.graph.impl.AbstractGraphObject;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class GraphNode<VALUETYPE>
extends AbstractGraphObject
implements IGraphNode<VALUETYPE> {
    private final VALUETYPE m_aValue;
    private Map<String, IGraphRelation<VALUETYPE>> m_aIncoming;
    private Map<String, IGraphRelation<VALUETYPE>> m_aOutgoing;

    public GraphNode() {
        this(null, null);
    }

    public GraphNode(@Nullable VALUETYPE aValue) {
        this(null, aValue);
    }

    public GraphNode(@Nullable String sID, @Nullable VALUETYPE aValue) {
        super(sID);
        this.m_aValue = aValue;
    }

    @Override
    @Nullable
    public VALUETYPE getValue() {
        return this.m_aValue;
    }

    @Override
    public void addIncomingRelation(@Nonnull IGraphRelation<VALUETYPE> aNewRelation) {
        if (aNewRelation == null) {
            throw new NullPointerException("relation");
        }
        if (aNewRelation.getTo() != this) {
            throw new IllegalArgumentException("Passed incoming relation is not based on this node");
        }
        if (this.m_aIncoming != null) {
            if (this.m_aIncoming.containsKey(aNewRelation.getID())) {
                throw new IllegalArgumentException("The passed relation (" + aNewRelation + ") is already contained as an incoming relation");
            }
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aIncoming.values()) {
                if (aRelation.getFrom() != aNewRelation.getFrom()) continue;
                throw new IllegalArgumentException("The from-node of the passed relation (" + aNewRelation + ") is already contained");
            }
        } else {
            this.m_aIncoming = new LinkedHashMap<String, IGraphRelation<VALUETYPE>>();
        }
        this.m_aIncoming.put((String)aNewRelation.getID(), aNewRelation);
    }

    @Override
    public boolean hasIncomingRelations() {
        return !ContainerHelper.isEmpty(this.m_aIncoming);
    }

    @Override
    @Nonnegative
    public int getIncomingRelationCount() {
        return ContainerHelper.getSize(this.m_aIncoming);
    }

    @Override
    public boolean isIncomingRelation(@Nullable IGraphRelation<VALUETYPE> aRelation) {
        return this.m_aIncoming != null && aRelation != null && aRelation.equals(this.m_aIncoming.get(aRelation.getID()));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<IGraphRelation<VALUETYPE>> getIncomingRelations() {
        return this.m_aIncoming == null ? new ArrayList() : ContainerHelper.newList(this.m_aIncoming.values());
    }

    @Override
    public boolean isFromNode(@Nullable IGraphNode<VALUETYPE> aNode) {
        if (this.m_aIncoming != null && aNode != null) {
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aIncoming.values()) {
                if (!aRelation.getFrom().equals(aNode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<IGraphNode<VALUETYPE>> getAllFromNodes() {
        HashSet<IGraphNode<VALUETYPE>> ret = new HashSet<IGraphNode<VALUETYPE>>();
        if (this.m_aIncoming != null) {
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aIncoming.values()) {
                ret.add(aRelation.getFrom());
            }
        }
        return ret;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<VALUETYPE> getAllFromValues() {
        ArrayList<VALUETYPE> ret = new ArrayList<VALUETYPE>();
        if (this.m_aIncoming != null) {
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aIncoming.values()) {
                ret.add(aRelation.getFromValue());
            }
        }
        return ret;
    }

    @Override
    public void addOutgoingRelation(@Nonnull IGraphRelation<VALUETYPE> aNewRelation) {
        if (aNewRelation == null) {
            throw new NullPointerException("relation");
        }
        if (aNewRelation.getFrom() != this) {
            throw new IllegalArgumentException("Passed outgoing relation is not based on this node");
        }
        if (this.m_aOutgoing != null) {
            if (this.m_aOutgoing.containsKey(aNewRelation.getID())) {
                throw new IllegalArgumentException("The passed relation " + aNewRelation + " is already contained as an outgoing relation");
            }
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aOutgoing.values()) {
                if (aRelation.getTo() != aNewRelation.getTo()) continue;
                throw new IllegalArgumentException("The to-node of the passed relation " + aNewRelation + " is already contained");
            }
        } else {
            this.m_aOutgoing = new LinkedHashMap<String, IGraphRelation<VALUETYPE>>();
        }
        this.m_aOutgoing.put((String)aNewRelation.getID(), aNewRelation);
    }

    @Override
    public boolean hasOutgoingRelations() {
        return !ContainerHelper.isEmpty(this.m_aOutgoing);
    }

    @Override
    @Nonnegative
    public int getOutgoingRelationCount() {
        return ContainerHelper.getSize(this.m_aOutgoing);
    }

    @Override
    public boolean isOutgoingRelation(@Nullable IGraphRelation<VALUETYPE> aRelation) {
        return this.m_aOutgoing != null && aRelation != null && aRelation.equals(this.m_aOutgoing.get(aRelation.getID()));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<IGraphRelation<VALUETYPE>> getOutgoingRelations() {
        return this.m_aOutgoing == null ? new ArrayList() : ContainerHelper.newList(this.m_aOutgoing.values());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<IGraphNode<VALUETYPE>> getAllToNodes() {
        HashSet<IGraphNode<VALUETYPE>> ret = new HashSet<IGraphNode<VALUETYPE>>();
        if (this.m_aOutgoing != null) {
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aOutgoing.values()) {
                ret.add(aRelation.getTo());
            }
        }
        return ret;
    }

    @Override
    public boolean isToNode(@Nullable IGraphNode<VALUETYPE> aNode) {
        if (this.m_aOutgoing != null && aNode != null) {
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aOutgoing.values()) {
                if (!aRelation.getTo().equals(aNode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<VALUETYPE> getAllToValues() {
        ArrayList<VALUETYPE> ret = new ArrayList<VALUETYPE>();
        if (this.m_aOutgoing != null) {
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aOutgoing.values()) {
                ret.add(aRelation.getToValue());
            }
        }
        return ret;
    }

    @Override
    public boolean isConnectedWith(@Nullable IGraphNode<VALUETYPE> aNode) {
        return this.isFromNode(aNode) || this.isToNode(aNode);
    }

    @Override
    public boolean hasIncomingOrOutgoingRelations() {
        return this.hasIncomingRelations() || this.hasOutgoingRelations();
    }

    @Override
    public boolean hasIncomingAndOutgoingRelations() {
        return this.hasIncomingRelations() && this.hasOutgoingRelations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<IGraphRelation<VALUETYPE>> getAllRelations() {
        HashSet<IGraphRelation<VALUETYPE>> ret = new HashSet<IGraphRelation<VALUETYPE>>();
        if (this.m_aIncoming != null) {
            ret.addAll(this.m_aIncoming.values());
        }
        if (this.m_aOutgoing != null) {
            ret.addAll(this.m_aOutgoing.values());
        }
        return ret;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<IGraphNode<VALUETYPE>> getAllRelatedNodes() {
        HashSet<IGraphNode<VALUETYPE>> ret = new HashSet<IGraphNode<VALUETYPE>>();
        if (this.m_aIncoming != null) {
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aIncoming.values()) {
                ret.add(aRelation.getFrom());
            }
        }
        if (this.m_aOutgoing != null) {
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aOutgoing.values()) {
                ret.add(aRelation.getTo());
            }
        }
        return ret;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<VALUETYPE> getAllRelatedValues() {
        HashSet<VALUETYPE> ret = new HashSet<VALUETYPE>();
        if (this.m_aIncoming != null) {
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aIncoming.values()) {
                ret.add(aRelation.getFromValue());
            }
        }
        if (this.m_aOutgoing != null) {
            for (IGraphRelation<VALUETYPE> aRelation : this.m_aOutgoing.values()) {
                ret.add(aRelation.getToValue());
            }
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        GraphNode rhs = (GraphNode)o;
        return EqualsUtils.equals(this.m_aValue, rhs.m_aValue);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aValue).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("value", this.m_aValue).append("incomingIDs", this.m_aIncoming == null ? null : this.m_aIncoming.keySet()).append("outgoingIDs", this.m_aOutgoing == null ? null : this.m_aOutgoing.keySet()).toString();
    }
}

