/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.gfx;

import com.phloc.commons.collections.LRUCache;
import com.phloc.commons.gfx.ScalableSize;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.state.EChange;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import com.phloc.commons.stats.StatisticsManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ImageDataManager {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ImageDataManager.class);
    private static final IStatisticsHandlerCache s_aStatsHdl = StatisticsManager.getCacheHandler(ImageDataManager.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<IReadableResource, ScalableSize> s_aImageData = new LRUCache<IReadableResource, ScalableSize>(1000);
    private static final Set<IReadableResource> s_aNonExistingResources = new HashSet<IReadableResource>();
    private static final ImageDataManager s_aInstance = new ImageDataManager();

    private ImageDataManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ScalableSize _readImageData(@Nonnull IInputStreamProvider aRes) {
        ScalableSize aData = null;
        InputStream aIS = null;
        try {
            aIS = aRes.getInputStream();
            if (aIS != null) {
                BufferedImage aImage = ImageIO.read(aIS);
                if (aImage != null) {
                    aData = new ScalableSize(aImage.getWidth(), aImage.getHeight());
                } else {
                    s_aLogger.warn("Does not seem to be an image resource: " + aRes);
                }
            } else {
                s_aLogger.warn("Failed to resolve image resource: " + aRes);
            }
        }
        catch (UnsatisfiedLinkError ex) {
            s_aLogger.error("Seems like no AWT binding is present", (Throwable)ex);
        }
        catch (NoClassDefFoundError ex) {
            s_aLogger.error("Seems like no AWT binding is present", (Throwable)ex);
        }
        catch (IIOException ex) {
            s_aLogger.error("Failed to interprete image data from resource " + aRes + ": " + ex.getMessage());
        }
        catch (IOException ex) {
            s_aLogger.error("Failed to read image data from resource " + aRes, (Throwable)ex);
        }
        catch (AccessControlException ex) {
            s_aLogger.error("Whatsoever on " + aRes, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            s_aLogger.error("Failed to read image data from resource " + aRes + ": " + ex.getMessage());
        }
        finally {
            StreamUtils.close(aIS);
        }
        return aData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ScalableSize getImageSize(@Nullable IReadableResource aRes) {
        ScalableSize aData;
        if (aRes == null) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            aData = s_aImageData.get(aRes);
            if (aData != null) {
                s_aStatsHdl.cacheHit();
                ScalableSize scalableSize = aData;
                return scalableSize;
            }
            if (s_aNonExistingResources.contains(aRes)) {
                s_aStatsHdl.cacheHit();
                ScalableSize scalableSize = null;
                return scalableSize;
            }
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        aData = ImageDataManager._readImageData(aRes);
        s_aRWLock.writeLock().lock();
        try {
            if (aData == null) {
                s_aNonExistingResources.add(aRes);
            } else {
                s_aImageData.put(aRes, aData);
            }
            s_aStatsHdl.cacheMiss();
            ScalableSize scalableSize = aData;
            return scalableSize;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange clearCachedSize(@Nullable IReadableResource aRes) {
        if (aRes != null) {
            s_aRWLock.writeLock().lock();
            try {
                if (s_aImageData.remove(aRes) != null) {
                    EChange eChange = EChange.CHANGED;
                    return eChange;
                }
                if (s_aNonExistingResources.remove(aRes)) {
                    EChange eChange = EChange.CHANGED;
                    return eChange;
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return EChange.UNCHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange clearCache() {
        s_aRWLock.writeLock().lock();
        try {
            if (s_aImageData.isEmpty() && s_aNonExistingResources.isEmpty()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            s_aImageData.clear();
            s_aNonExistingResources.clear();
            s_aLogger.info("Cache was cleared: " + ImageDataManager.class.getName());
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }
}

