/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.filter;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FilterChainAND<DATATYPE>
implements IFilter<DATATYPE> {
    private final List<? extends IFilter<? super DATATYPE>> m_aFilters;

    public FilterChainAND(IFilter<? super DATATYPE> ... aFilters) {
        this.m_aFilters = ContainerHelper.newList(aFilters);
    }

    public FilterChainAND(@Nullable Iterable<? extends IFilter<? super DATATYPE>> aFilters) {
        this.m_aFilters = ContainerHelper.newList(aFilters);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<? extends IFilter<? super DATATYPE>> getContainedFilters() {
        return ContainerHelper.newList(this.m_aFilters);
    }

    @Override
    public boolean matchesFilter(@Nullable DATATYPE aValue) {
        for (IFilter<DATATYPE> aFilter : this.m_aFilters) {
            if (aFilter.matchesFilter(aValue)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterChainAND)) {
            return false;
        }
        FilterChainAND rhs = (FilterChainAND)o;
        return ((Object)this.m_aFilters).equals(rhs.m_aFilters);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aFilters)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("filters", this.m_aFilters).toString();
    }

    @Nonnull
    public static <DATATYPE> FilterChainAND<DATATYPE> create(IFilter<? super DATATYPE> ... aFilters) {
        return new FilterChainAND<DATATYPE>(aFilters);
    }

    @Nonnull
    public static <DATATYPE> FilterChainAND<DATATYPE> create(@Nullable Iterable<? extends IFilter<? super DATATYPE>> aFilters) {
        return new FilterChainAND<DATATYPE>(aFilters);
    }
}

