/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.exceptions;

import com.phloc.commons.exceptions.ILoggedException;
import com.phloc.commons.exceptions.LoggedRuntimeException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggedException
extends Exception
implements ILoggedException {
    public static final boolean DEFAULT_DO_LOG = true;
    private static final Logger s_aLogger = LoggerFactory.getLogger((String)"ROOT");
    private static final String MSG_TEXT = "Exception created.";

    public LoggedException() {
        this(true);
    }

    public LoggedException(boolean bLog) {
        if (bLog) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedException(@Nullable String sMsg) {
        this(true, sMsg);
    }

    public LoggedException(boolean bLog, @Nullable String sMsg) {
        super(sMsg);
        if (bLog) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedException(@Nullable Throwable t) {
        this(true, t);
    }

    public LoggedException(boolean bLog, @Nullable Throwable t) {
        super(t);
        if (bLog) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedException(@Nullable String sMsg, @Nullable Throwable t) {
        this(true, sMsg, t);
    }

    public LoggedException(boolean bLog, @Nullable String sMsg, @Nullable Throwable t) {
        super(sMsg, t);
        if (bLog) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    @Nonnull
    public static Exception newException(@Nullable Throwable t) {
        if (t instanceof LoggedException) {
            return (LoggedException)t;
        }
        if (t instanceof LoggedRuntimeException) {
            return new Exception(t);
        }
        return new LoggedException(t);
    }

    @Nonnull
    public static Exception newException(@Nullable String sMsg, @Nullable Throwable t) {
        if (t instanceof LoggedException) {
            return (LoggedException)t;
        }
        if (t instanceof LoggedRuntimeException) {
            return new Exception(sMsg, t);
        }
        return new LoggedException(sMsg, t);
    }
}

