/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.error;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.error.ISeverityComparable;
import com.phloc.commons.id.IHasID;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.state.IErrorIndicator;
import com.phloc.commons.state.ISuccessIndicator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EErrorLevel implements IHasID<String>,
ISuccessIndicator,
IErrorIndicator,
ISeverityComparable<EErrorLevel>
{
    SUCCESS("success", 0),
    INFO("info", 100),
    WARN("warn", 200),
    ERROR("error", 300),
    FATAL_ERROR("fatal_error", 400);

    public static final EErrorLevel LOWEST;
    public static final EErrorLevel HIGHEST;
    private final String m_sID;
    private final int m_nNumericLevel;

    private EErrorLevel(String sID, int nNumericLevel) {
        this.m_sID = sID;
        this.m_nNumericLevel = nNumericLevel;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    public boolean isSuccess() {
        return this == SUCCESS;
    }

    @Override
    public boolean isFailure() {
        return this != SUCCESS;
    }

    @Override
    public boolean isError() {
        return this.isMoreOrEqualSevereThan(ERROR);
    }

    @Override
    public boolean isNoError() {
        return this.isLessSevereThan(ERROR);
    }

    @Nonnegative
    public int getNumericLevel() {
        return this.m_nNumericLevel;
    }

    @Override
    public boolean isEqualSevereThan(@Nonnull EErrorLevel eErrorLevel) {
        return this.getNumericLevel() == eErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isLessSevereThan(@Nonnull EErrorLevel eErrorLevel) {
        return this.getNumericLevel() < eErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isLessOrEqualSevereThan(@Nonnull EErrorLevel eErrorLevel) {
        return this.getNumericLevel() <= eErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isMoreSevereThan(@Nonnull EErrorLevel eErrorLevel) {
        return this.getNumericLevel() > eErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isMoreOrEqualSevereThan(@Nonnull EErrorLevel eErrorLevel) {
        return this.getNumericLevel() >= eErrorLevel.getNumericLevel();
    }

    @Nullable
    public static EErrorLevel getMostSevere(@Nullable EErrorLevel eLevel1, @Nullable EErrorLevel eLevel2) {
        if (eLevel1 == eLevel2) {
            return eLevel1;
        }
        if (eLevel1 == null) {
            return eLevel2;
        }
        if (eLevel2 == null) {
            return eLevel1;
        }
        return eLevel1.isMoreSevereThan(eLevel2) ? eLevel1 : eLevel2;
    }

    @Nullable
    public static EErrorLevel getFromIDOrNull(@Nullable String sID) {
        return EnumHelper.getFromIDOrNull(EErrorLevel.class, sID);
    }

    @Nonnull
    public static EErrorLevel getFromIDOrThrow(@Nullable String sID) {
        return EnumHelper.getFromIDOrThrow(EErrorLevel.class, sID);
    }

    @Nullable
    public static EErrorLevel getFromIDOrDefault(@Nullable String sID, @Nullable EErrorLevel eDefault) {
        return EnumHelper.getFromIDOrDefault(EErrorLevel.class, sID, eDefault);
    }

    static {
        LOWEST = SUCCESS;
        HIGHEST = FATAL_ERROR;
    }
}

