/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.list;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.MustImplementEqualsAndHashcode;
import com.phloc.commons.factory.FactoryNull;
import com.phloc.commons.factory.IFactory;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Vector;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SafeVector<ELEMENTTYPE>
extends Vector<ELEMENTTYPE>
implements IHasSize {
    @MustImplementEqualsAndHashcode
    private final IFactory<ELEMENTTYPE> m_aFactory;

    public SafeVector() {
        this(FactoryNull.getInstance());
    }

    public SafeVector(@Nonnull IFactory<ELEMENTTYPE> aFactory) {
        if (aFactory == null) {
            throw new NullPointerException("If you use the constructor with an IFactory you have to provide anything other than null.");
        }
        this.m_aFactory = aFactory;
    }

    private void _ensureSize(@Nonnegative int nIndex) {
        while (this.size() <= nIndex) {
            this.add(this.m_aFactory.create());
        }
    }

    @Override
    public synchronized ELEMENTTYPE get(@Nonnegative int nIndex) {
        this._ensureSize(nIndex);
        return (ELEMENTTYPE)super.get(nIndex);
    }

    @Override
    public synchronized ELEMENTTYPE set(@Nonnegative int nIndex, @Nonnull ELEMENTTYPE aElement) {
        this._ensureSize(nIndex);
        return super.set(nIndex, aElement);
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SafeVector rhs = (SafeVector)o;
        return this.m_aFactory.equals(rhs.m_aFactory);
    }

    @Override
    public synchronized int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public synchronized String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("factory", this.m_aFactory).toString();
    }
}

