/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.collections.iterate.EmptyEnumeration;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CombinedEnumeration<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private final Enumeration<? extends ELEMENTTYPE> m_aEnum1;
    private final Enumeration<? extends ELEMENTTYPE> m_aEnum2;
    private boolean m_bFirstEnum;

    public CombinedEnumeration(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum1, @Nullable Enumeration<? extends ELEMENTTYPE> aEnum2) {
        this.m_aEnum1 = aEnum1;
        this.m_aEnum2 = aEnum2;
        this.m_bFirstEnum = aEnum1 != null;
    }

    @Override
    public boolean hasMoreElements() {
        boolean ret = false;
        if (this.m_bFirstEnum) {
            boolean bl = ret = this.m_aEnum1 != null && this.m_aEnum1.hasMoreElements();
            if (!ret) {
                this.m_bFirstEnum = false;
            }
        }
        if (!this.m_bFirstEnum) {
            ret = this.m_aEnum2 != null && this.m_aEnum2.hasMoreElements();
        }
        return ret;
    }

    @Override
    @Nullable
    public ELEMENTTYPE nextElement() {
        if (this.m_bFirstEnum) {
            return this.m_aEnum1.nextElement();
        }
        if (this.m_aEnum2 == null) {
            throw new NoSuchElementException();
        }
        return this.m_aEnum2.nextElement();
    }

    public String toString() {
        return new ToStringGenerator(this).append("enum1", this.m_aEnum1).append("enum2", this.m_aEnum2).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> create(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum1, @Nullable Enumeration<? extends ELEMENTTYPE> aEnum2) {
        if (aEnum1 == null && aEnum2 == null) {
            return EmptyEnumeration.getInstance();
        }
        return new CombinedEnumeration<ELEMENTTYPE>(aEnum1, aEnum2);
    }
}

