/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.UseDirectEqualsAndHashCode;
import com.phloc.commons.collections.LRUCache;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@UseDirectEqualsAndHashCode
@NotThreadSafe
public class LRUSet<ELEMENTTYPE>
extends AbstractSet<ELEMENTTYPE>
implements IHasSize,
Serializable {
    private final LRUCacheMap<ELEMENTTYPE> m_aCache;

    public LRUSet(@Nonnegative int nMaxSize) {
        this.m_aCache = new LRUCacheMap(nMaxSize, this);
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnull ELEMENTTYPE aEldest) {
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_aCache.getMaxSize();
    }

    @Override
    public boolean add(@Nullable ELEMENTTYPE aItem) {
        if (this.contains(aItem)) {
            return false;
        }
        this.m_aCache.put(aItem, Boolean.TRUE);
        return true;
    }

    @Override
    @Nonnull
    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_aCache.keySet().iterator();
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aCache.size();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LRUSet)) {
            return false;
        }
        LRUSet rhs = (LRUSet)o;
        return this.m_aCache.equals(rhs.m_aCache);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aCache)).getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("cache", this.m_aCache).toString();
    }

    @UseDirectEqualsAndHashCode
    private static final class LRUCacheMap<ELEMENTTYPE>
    extends LRUCache<ELEMENTTYPE, Boolean> {
        private final LRUSet<ELEMENTTYPE> m_aOwningSet;

        private LRUCacheMap(@Nonnegative int nMaxSize, @Nonnull LRUSet<ELEMENTTYPE> aOwningSet) {
            super(nMaxSize);
            this.m_aOwningSet = aOwningSet;
        }

        @Override
        protected void onRemoveEldestEntry(Map.Entry<ELEMENTTYPE, Boolean> aEldest) {
            this.m_aOwningSet.onRemoveEldestEntry(aEldest.getKey());
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

