/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.icp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import org.w3c.www.protocol.http.icp.ICPFilter;
import org.w3c.www.protocol.http.icp.ICPMessage;

class ICPSender {
    protected ICPFilter filter = null;
    protected InetAddress addr = null;
    protected int port = -1;
    protected URL proxy = null;
    protected byte[] buffer = null;

    public String toString() {
        return this.getAddress() + "/" + this.getPort();
    }

    public final URL getProxyLocation() {
        return this.proxy;
    }

    public final InetAddress getAddress() {
        return this.addr;
    }

    public final int getPort() {
        return this.port;
    }

    public boolean send(ICPMessage iCPMessage) {
        int n = iCPMessage.toByteArray(this.buffer);
        if (n < 0) {
            this.buffer = new byte[-n + 1];
            n = iCPMessage.toByteArray(this.buffer);
        }
        DatagramPacket datagramPacket = new DatagramPacket(this.buffer, n, this.addr, this.port);
        try {
            this.filter.getSocket().send(datagramPacket);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    ICPSender(ICPFilter iCPFilter, int n, InetAddress inetAddress, int n2, URL uRL) throws SocketException {
        this.filter = iCPFilter;
        this.addr = inetAddress;
        this.port = n2;
        this.proxy = uRL;
        this.buffer = new byte[512];
    }
}

