/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.icp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.URL;
import org.w3c.www.protocol.http.icp.ICP;
import org.w3c.www.protocol.http.icp.ICPProtocolException;
import org.w3c.www.protocol.http.icp.ICPQuery;
import org.w3c.www.protocol.http.icp.ICPReply;

class ICPMessage
implements ICP {
    protected int opcode = -1;
    protected int version = -1;
    protected int id = -1;
    protected int options = 0;
    protected InetAddress addr = null;
    protected int port = -1;
    URL url = null;

    ICPMessage() {
    }

    protected static ICPMessage parse(DatagramPacket datagramPacket) throws ICPProtocolException {
        byte[] byArray = datagramPacket.getData();
        int n = datagramPacket.getLength();
        if (n < 4) {
            throw new ICPProtocolException("Invalid ICP datagram length");
        }
        InetAddress inetAddress = datagramPacket.getAddress();
        int n2 = datagramPacket.getPort();
        byte by = byArray[0];
        byte by2 = byArray[1];
        int n3 = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        if (n3 != n) {
            throw new ICPProtocolException("Didn't got full message: " + n + "/" + n3);
        }
        ICPMessage iCPMessage = null;
        switch (by) {
            case 1: {
                iCPMessage = new ICPQuery(inetAddress, n2, by, by2, byArray, 4, n);
                break;
            }
            case 2: 
            case 3: {
                iCPMessage = new ICPReply(inetAddress, n2, by, by2, byArray, 4, n);
                break;
            }
            default: {
                throw new ICPProtocolException("Unsupported opcode: " + by);
            }
        }
        return iCPMessage;
    }

    protected int parse(byte[] byArray, int n, int n2) throws ICPProtocolException {
        this.id = ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 3] & 0xFF) << 0);
        this.options = ((byArray[n += 4] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 3] & 0xFF) << 0);
        n += 4;
        return n += 4;
    }

    protected int getByteArrayLength() {
        return 16;
    }

    protected int toByteArray(byte[] byArray) {
        int n = this.getByteArrayLength();
        if (n > byArray.length) {
            return -n;
        }
        byArray[0] = (byte)this.opcode;
        byArray[1] = 3;
        byArray[2] = (byte)(n >>> 8 & 0xFF);
        byArray[3] = (byte)(n >>> 0 & 0xFF);
        byArray[4] = (byte)(this.id >>> 24 & 0xFF);
        byArray[5] = (byte)(this.id >>> 16 & 0xFF);
        byArray[6] = (byte)(this.id >>> 8 & 0xFF);
        byArray[7] = (byte)(this.id >>> 0 & 0xFF);
        byArray[8] = (byte)(this.options >>> 24 & 0xFF);
        byArray[9] = (byte)(this.options >>> 16 & 0xFF);
        byArray[10] = (byte)(this.options >>> 8 & 0xFF);
        byArray[11] = (byte)(this.options >>> 0 & 0xFF);
        return 16;
    }

    protected final int getIdentifier() {
        return this.id;
    }

    protected final int getOpcode() {
        return this.opcode;
    }

    protected final URL getURL() {
        return this.url;
    }

    public InetAddress getSenderAddress() {
        return this.addr;
    }

    public int getSenderPort() {
        return this.port;
    }
}

