/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.util.URLUtils;
import org.w3c.www.http.HTTP;
import org.w3c.www.http.HttpCacheControl;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpInvalidValueException;
import org.w3c.www.http.HttpWarning;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilter;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cache.ActiveStream;
import org.w3c.www.protocol.http.cache.CacheSerializer;
import org.w3c.www.protocol.http.cache.CacheStore;
import org.w3c.www.protocol.http.cache.CacheSweeper;
import org.w3c.www.protocol.http.cache.CacheValidator;
import org.w3c.www.protocol.http.cache.CachedResource;
import org.w3c.www.protocol.http.cache.CachedResourceFactory;
import org.w3c.www.protocol.http.cache.EntityCachedResource;
import org.w3c.www.protocol.http.cache.InvalidCacheException;

public class CacheFilter
implements PropRequestFilter,
PropertyMonitoring {
    public static final String SERIALIZER_P = "org.w3c.www.protocol.http.cache.serializerclass";
    public static final String SWEEPER_P = "org.w3c.www.protocol.http.cache.sweeperclass";
    public static final String VALIDATOR_P = "org.w3c.www.protocol.http.cache.validatorclass";
    public static final String CACHE_CONNECTED_P = "org.w3c.www.protocol.http.cache.connected";
    public static final String SHARED_P = "org.w3c.www.protocol.http.cache.shared";
    public static final String CACHE_SIZE_P = "org.w3c.www.protocol.http.cache.size";
    public static final String DEBUG_P = "org.w3c.www.protocol.http.cache.debug";
    public static final String STATE_NOCACHE = "org.w3c.www.protocol.http.cache.dont";
    public static final String STATE_WARNINGS = "org.w3c.www.protocol.http.cache.CacheFilter.warns";
    public static final String STATE_ORIGREQ = "org.w3c.www.protocol.http.cache.CacheFilter.origreq";
    public static final String STATE_REVALIDATION = "org.w3c.www.protocol.http.cache.revalidation";
    protected static HttpWarning WARN_DISCONNECTED = null;
    protected static HttpWarning WARN_STALE = null;
    protected static HttpWarning WARN_HEURISTIC = null;
    protected ObservableProperties props = null;
    protected CacheValidator validator;
    protected CacheStore store;
    protected CacheSweeper sweeper;
    protected CacheSerializer serializer;
    protected boolean connected = true;
    protected boolean shared = true;
    protected long size = 0x1400000L;
    protected File directory = null;
    protected boolean debug = false;
    protected Hashtable precache = new Hashtable(10);
    protected Hashtable uritable = new Hashtable(10);

    public CacheSweeper getSweeper() {
        return this.sweeper;
    }

    public CacheSerializer getSerializer() {
        return this.serializer;
    }

    public CacheValidator getValidator() {
        return this.validator;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected final void trace(Request request, String string) {
        System.out.println(request.getURL() + ": " + string);
    }

    protected void addWarning(Request request, HttpWarning httpWarning) {
        Vector<HttpWarning> vector = (Vector<HttpWarning>)request.getState(STATE_WARNINGS);
        if (vector == null) {
            vector = new Vector<HttpWarning>(4);
            request.setState(STATE_WARNINGS, vector);
        }
        vector.addElement(httpWarning);
    }

    protected final void setWarnings(Request request, Reply reply) {
        Vector vector = (Vector)request.getState(STATE_WARNINGS);
        if (vector == null) {
            return;
        }
        Object[] objectArray = new HttpWarning[vector.size()];
        vector.copyInto(objectArray);
        reply.setWarning((HttpWarning[])objectArray);
    }

    public boolean canUseCache(Request request) {
        if (request.hasPragma("no-cache") || request.getNoCache() != null) {
            request.setState(STATE_NOCACHE, Boolean.TRUE);
            return false;
        }
        if (request.checkNoStore()) {
            request.setState("org.w3c.www.protocol.http.cache.storable", Boolean.FALSE);
            return false;
        }
        String string = request.getMethod();
        if (!string.equals("GET") && !string.equals("HEAD")) {
            request.setState(STATE_NOCACHE, Boolean.TRUE);
            return false;
        }
        return true;
    }

    public boolean canCache(Request request, Reply reply) {
        String string = request.getMethod();
        if (!string.equals("GET")) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        if (request.getMajorVersion() == 0) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        if (reply.getSetCookie() != null) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        int n = reply.getStatus();
        if (n != 200 && n != 203 && n != 206 && n != 300 && n != 301 && n != 410) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        HttpCacheControl httpCacheControl = null;
        try {
            httpCacheControl = reply.getCacheControl();
        }
        catch (HttpInvalidValueException httpInvalidValueException) {
            httpCacheControl = HttpFactory.parseCacheControl("no-cache");
            reply.setCacheControl(httpCacheControl);
        }
        if (httpCacheControl != null) {
            if (httpCacheControl.checkPublic()) {
                reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.TRUE);
                return true;
            }
            if (this.isShared() && httpCacheControl.getPrivate() != null) {
                reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
                return false;
            }
        }
        if (reply.getNoCache() != null) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        if (reply.hasPragma("no-cache")) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        if (request.getURL().getFile().indexOf(63) != -1 && reply.getMajorVersion() == 1 && reply.getMinorVersion() == 0 && reply.getExpires() == -1L) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        if (request.hasAuthorization()) {
            reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.FALSE);
            return false;
        }
        reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.TRUE);
        return true;
    }

    public boolean canStore(Request request, Reply reply) {
        if (request.checkNoStore() || reply.checkNoStore()) {
            reply.setState("org.w3c.www.protocol.http.cache.storable", Boolean.FALSE);
            return false;
        }
        reply.setState("org.w3c.www.protocol.http.cache.cachable", Boolean.TRUE);
        return true;
    }

    protected Request setRequestRevalidation(CachedResource cachedResource, Request request) {
        try {
            return this.store.getCachedResource(cachedResource).setRequestRevalidation(request);
        }
        catch (InvalidCacheException invalidCacheException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply ingoingFilter(Request request) throws HttpException {
        if (!this.canUseCache(request)) {
            if (this.debug) {
                this.trace(request, "*** Can't use cache");
            }
            if (this.connected) {
                CachedResource cachedResource = null;
                CachedResource cachedResource2 = null;
                try {
                    URL uRL = request.getURL();
                    String string = URLUtils.normalize(uRL).toExternalForm();
                    cachedResource = this.store.getCachedResourceReference(string);
                    if (cachedResource != null) {
                        cachedResource2 = (EntityCachedResource)cachedResource.lookupResource(request);
                    }
                }
                catch (InvalidCacheException invalidCacheException) {
                    cachedResource2 = null;
                }
                if (cachedResource2 != null) {
                    cachedResource2.setWillRevalidate(true);
                }
                request.setState(STATE_NOCACHE, Boolean.TRUE);
                return null;
            }
            Reply reply = request.makeReply(504);
            reply.setContent("The cache cannot be use for <p><code>" + request.getMethod() + "</code> " + "<strong>" + request.getURL() + "</strong>" + ". <p>It is disconnected.");
            return reply;
        }
        URL uRL = request.getURL();
        String string = URLUtils.normalize(uRL).toExternalForm();
        if (this.precache.containsKey(string)) {
            if (this.debug) {
                System.out.println("*** Already downloading: " + string);
            }
            try {
                CachedResource cachedResource = (CachedResource)this.precache.get(string);
                return cachedResource.perform(request);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CachedResource cachedResource = null;
        try {
            cachedResource = this.store.getCachedResourceReference(string);
        }
        catch (InvalidCacheException invalidCacheException) {
            cachedResource = null;
        }
        if (request.checkOnlyIfCached() || !this.connected) {
            EntityCachedResource entityCachedResource = null;
            if (cachedResource != null) {
                entityCachedResource = (EntityCachedResource)cachedResource.lookupResource(request);
            }
            if (cachedResource == null || entityCachedResource == null) {
                if (this.debug) {
                    this.trace(request, "unavailable (disconnected).");
                }
                Reply reply = request.makeReply(504);
                reply.setContent("The cache doesn't have an entry for <p><strong>" + request.getURL() + "</strong>" + ". <p>And it is disconnected.");
                return reply;
            }
            if (this.debug) {
                this.trace(request, this.connected ? " hit - only if cached" : " hit while disconneced");
            }
            if (!this.validator.isValid(entityCachedResource, request)) {
                this.addWarning(request, WARN_STALE);
            }
            this.addWarning(request, WARN_DISCONNECTED);
            Reply reply = entityCachedResource.perform(request);
            this.setWarnings(request, reply);
            return reply;
        }
        if (cachedResource != null) {
            if (cachedResource.getLoadState() == 2 || cachedResource.getLoadState() == 4) {
                this.setRequestRevalidation(cachedResource, request);
                return null;
            }
            if (this.validator.isValid(cachedResource, request)) {
                try {
                    this.store.updateResourceGeneration(cachedResource);
                }
                catch (InvalidCacheException invalidCacheException) {
                    // empty catch block
                }
                Reply reply = cachedResource.perform(request);
                return reply;
            }
            if (this.debug) {
                System.out.println("*** Revalidation asked for " + string);
            }
            this.setRequestRevalidation(cachedResource, request);
            return null;
        }
        while (this.uritable.containsKey(string)) {
            Cloneable cloneable = this.uritable;
            synchronized (cloneable) {
                try {
                    this.uritable.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.precache.containsKey(string)) {
                if (this.debug) {
                    System.out.println("*** Already downloading: " + string);
                }
                cloneable = (CachedResource)this.precache.get(string);
                return ((CachedResource)cloneable).perform(request);
            }
            this.uritable.put(string, string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exceptionFilter(Request request, HttpException httpException) {
        URL uRL = request.getURL();
        String string = URLUtils.normalize(uRL).toExternalForm();
        Hashtable hashtable = this.uritable;
        synchronized (hashtable) {
            this.uritable.remove(string);
            this.uritable.notifyAll();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply outgoingFilter(Request request, Reply reply) throws HttpException {
        URL uRL = URLUtils.normalize(request.getURL());
        CachedResource cachedResource = (CachedResource)request.getState("org.w3c.www.protocol.http.cache.resource");
        if (cachedResource != null) {
            if (this.debug) {
                this.trace(request, "revalidated " + reply.getStatus());
            }
            if (reply.getStatus() == 304) {
                block15: {
                    this.validator.revalidateResource(cachedResource, request, reply);
                    try {
                        this.store.storeCachedResource(cachedResource, cachedResource.getCurrentLength());
                    }
                    catch (InvalidCacheException invalidCacheException) {
                        if (!this.debug) break block15;
                        invalidCacheException.printStackTrace();
                    }
                }
                Request request2 = (Request)request.getState(STATE_ORIGREQ);
                return cachedResource.perform(request2);
            }
            cachedResource.delete();
            this.store.getState().notifyResourceDeleted(cachedResource);
        }
        if (!this.canCache(request, reply)) {
            request.setState(STATE_NOCACHE, Boolean.TRUE);
            if (this.debug) {
                System.out.println("*** Can't cache reply");
            }
            String string = uRL.toExternalForm();
            this.precache.remove(string);
            Hashtable hashtable = this.uritable;
            synchronized (hashtable) {
                this.uritable.remove(string);
                this.uritable.notifyAll();
            }
            this.invalidateOnReply(request, reply);
            return null;
        }
        if (!this.canStore(request, reply)) {
            if (this.debug) {
                System.out.println("*** Can't store reply");
            }
            String string = uRL.toExternalForm();
            this.precache.remove(string);
            Hashtable hashtable = this.uritable;
            synchronized (hashtable) {
                this.uritable.remove(string);
                this.uritable.notifyAll();
            }
            this.invalidateOnReply(request, reply);
            return null;
        }
        this.pushDocument(request, reply);
        return null;
    }

    private void invalidateOnReply(Request request, Reply reply) {
        block14: {
            URL uRL = request.getURL();
            if (request.getMethod() == HTTP.POST || request.getMethod() == HTTP.PUT || request.getMethod() == HTTP.DELETE) {
                CachedResource cachedResource;
                String string;
                block13: {
                    String string2 = reply.getLocation();
                    string = reply.getContentLocation();
                    if (string2 != null) {
                        try {
                            URL uRL2 = new URL(string2);
                            if (!URLUtils.equalsProtocolHostPort(uRL, uRL2)) break block13;
                            cachedResource = null;
                            try {
                                cachedResource = this.store.getCachedResourceReference(string2);
                                if (cachedResource != null) {
                                    cachedResource.setWillRevalidate(true);
                                }
                            }
                            catch (InvalidCacheException invalidCacheException) {}
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                }
                if (string != null) {
                    try {
                        URL uRL3 = new URL(uRL, string);
                        if (!URLUtils.equalsProtocolHostPort(uRL, uRL3)) break block14;
                        cachedResource = null;
                        try {
                            String string3 = uRL3.toExternalForm();
                            cachedResource = this.store.getCachedResourceReference(string3);
                            if (cachedResource != null) {
                                cachedResource.setWillRevalidate(true);
                            }
                        }
                        catch (InvalidCacheException invalidCacheException) {}
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void sync() {
        if (this.debug) {
            System.out.println("*** Synching the CacheFilter");
        }
        try {
            this.store.sync();
        }
        catch (Exception exception) {
            System.err.println(this.getClass().getName() + ": Unable to save cache.");
        }
    }

    public boolean propertyChanged(String string) {
        if (string.equals(SERIALIZER_P)) {
            CacheSerializer cacheSerializer = null;
            try {
                Class<?> clazz = Class.forName(this.props.getString(string, null));
                cacheSerializer = (CacheSerializer)clazz.newInstance();
            }
            catch (Exception exception) {
                return false;
            }
            this.serializer = cacheSerializer;
            return true;
        }
        if (string.equals(SWEEPER_P)) {
            CacheSweeper cacheSweeper = null;
            try {
                Class<?> clazz = Class.forName(this.props.getString(string, null));
                cacheSweeper = (CacheSweeper)clazz.newInstance();
            }
            catch (Exception exception) {
                return false;
            }
            this.sweeper.destroy();
            this.sweeper = cacheSweeper;
            this.sweeper.start();
            return true;
        }
        if (string.equals(VALIDATOR_P)) {
            CacheValidator cacheValidator = null;
            try {
                Class<?> clazz = Class.forName(this.props.getString(string, null));
                cacheValidator = (CacheValidator)clazz.newInstance();
            }
            catch (Exception exception) {
                return false;
            }
            this.validator = cacheValidator;
            return true;
        }
        if (string.equals(DEBUG_P)) {
            this.debug = this.props.getBoolean(string, this.debug);
            return true;
        }
        if (string.equals(SHARED_P)) {
            this.shared = this.props.getBoolean(string, this.shared);
            return true;
        }
        if (string.equals(CACHE_CONNECTED_P)) {
            this.connected = this.props.getBoolean(string, true);
            return true;
        }
        return this.store.propertyChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDocument(Request request, Reply reply) {
        URL uRL = URLUtils.normalize(request.getURL());
        try {
            Hashtable hashtable = this.uritable;
            synchronized (hashtable) {
                CachedResource cachedResource = null;
                String string = uRL.toExternalForm();
                cachedResource = CachedResourceFactory.createResource(this, request, reply);
                if (cachedResource.uploading) {
                    this.precache.put(string, cachedResource);
                }
                this.uritable.remove(string);
                this.uritable.notifyAll();
            }
            if (this.debug) {
                this.trace(request, "enters cache.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected synchronized void cleanUpload(CachedResource cachedResource) {
        block2: {
            this.precache.remove(cachedResource.getIdentifier());
            try {
                this.store.storeCachedResource(cachedResource);
            }
            catch (InvalidCacheException invalidCacheException) {
                if (!this.debug) break block2;
                invalidCacheException.printStackTrace();
            }
        }
    }

    public CacheStore getStore() {
        return this.store;
    }

    public void initialize(HttpManager httpManager) throws PropRequestFilterException {
        block4: {
            this.props = httpManager.getProperties();
            this.shared = this.props.getBoolean(SHARED_P, true);
            this.connected = this.props.getBoolean(CACHE_CONNECTED_P, true);
            this.debug = this.props.getBoolean(DEBUG_P, false);
            String string = this.props.getString(VALIDATOR_P, "org.w3c.www.protocol.http.cache.SimpleCacheValidator");
            String string2 = this.props.getString(SWEEPER_P, "org.w3c.www.protocol.http.cache.SimpleCacheSweeper");
            String string3 = this.props.getString(SERIALIZER_P, "org.w3c.www.protocol.http.cache.SimpleCacheSerializer");
            try {
                Class<?> clazz = Class.forName(string);
                this.validator = (CacheValidator)clazz.newInstance();
                this.validator.initialize(this);
                clazz = Class.forName(string2);
                this.sweeper = (CacheSweeper)clazz.newInstance();
                this.sweeper.initialize(this);
                clazz = Class.forName(string3);
                this.serializer = (CacheSerializer)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new PropRequestFilterException("Unable to start cache");
            }
            this.store = new CacheStore();
            try {
                this.store.initialize(this);
            }
            catch (InvalidCacheException invalidCacheException) {
                if (!this.debug) break block4;
                invalidCacheException.printStackTrace();
            }
        }
        this.sweeper.start();
        ActiveStream.initialize();
        this.props.registerObserver(this);
        httpManager.setFilter(this);
    }

    static {
        HttpWarning httpWarning = null;
        httpWarning = HttpFactory.makeWarning(112);
        httpWarning.setAgent("Jigsaw");
        httpWarning.setText("The required cached resource is stale.");
        WARN_DISCONNECTED = httpWarning;
        httpWarning = HttpFactory.makeWarning(110);
        httpWarning.setAgent("Jigsaw");
        httpWarning.setText("The returned entry is stale.");
        WARN_STALE = httpWarning;
        httpWarning = HttpFactory.makeWarning(113);
        httpWarning.setAgent("Jigsaw");
        httpWarning.setText("Heuristic expiration time used on this entry.");
        WARN_HEURISTIC = httpWarning;
    }
}

