/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.io.IOException;
import java.io.OutputStream;

class HttpBuffer {
    private static final int INIT_SIZE = 128;
    byte[] buf = null;
    int len = 0;
    byte sep = 0;

    final void append(byte by) {
        this.ensureCapacity(1);
        this.buf[this.len++] = by;
    }

    final void append(char c) {
        this.append((byte)c);
    }

    final void append(int n) {
        this.append((byte)n);
    }

    final void appendLong(long l) {
        this.appendLong(l, -1, (byte)0);
    }

    final void appendLong(long l, int n, byte by) {
        boolean bl = l < 0L;
        int n2 = this.len;
        if (!bl) {
            l = -l;
        }
        while (l <= -10L) {
            this.append((byte)(48L - l % 10L));
            --n;
            l /= 10L;
        }
        this.append((byte)(48L - l));
        --n;
        if (bl) {
            this.append((byte)45);
            --n;
        }
        while (--n >= 0) {
            this.append(by);
        }
        int n3 = (this.len - n2) / 2;
        int n4 = this.len - 1;
        while (--n3 >= 0) {
            int n5 = n2 + this.len - n4 - 1;
            byte by2 = this.buf[n4];
            this.buf[n4] = this.buf[n5];
            this.buf[n5] = by2;
            --n4;
        }
    }

    final void appendInt(int n) {
        this.appendLong(n, -1, (byte)0);
    }

    final void appendInt(int n, int n2, byte by) {
        this.appendLong(n, n2, by);
    }

    final void ensureCapacity(int n) {
        int n2 = this.len + n;
        if (n2 >= this.buf.length) {
            int n3 = this.buf.length << 1;
            if (n3 < n2) {
                n3 = n2 + 1;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buf, 0, byArray, 0, this.len);
            this.buf = byArray;
        }
    }

    void append(byte[] byArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(byArray, n, this.buf, this.len, n2);
        this.len += n2;
    }

    final void append(byte[] byArray) {
        this.append(byArray, 0, byArray.length);
    }

    void append(String string) {
        int n = string.length();
        this.ensureCapacity(n);
        string.getBytes(0, n, this.buf, this.len);
        this.len += n;
    }

    void appendQuoted(String string) {
        this.append((byte)34);
        this.append(string);
        this.append((byte)34);
    }

    void append(String string, byte by, String string2) {
        this.append(string);
        this.append(by);
        this.append(string2);
    }

    void append(String string, byte by, int n) {
        this.append(string);
        this.append(by);
        this.appendInt(n);
    }

    void appendQuoted(String string, byte by, String string2) {
        this.append(string);
        this.append(by);
        this.append('\"');
        this.append(string2);
        this.append('\"');
    }

    void appendQuoted(String string, byte by, String[] stringArray) {
        this.append(string);
        if (stringArray.length > 0) {
            this.append(by);
            this.append((byte)34);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    this.append(',');
                }
                this.append(stringArray[i]);
            }
            this.append((byte)34);
        }
    }

    void append(String string, byte by, String[] stringArray) {
        this.append(string);
        if (stringArray.length > 0) {
            this.append(by);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    this.append(',');
                }
                this.append(stringArray[i]);
            }
        }
    }

    void append(double d) {
        this.append(Double.toString(d));
    }

    public String toString() {
        return new String(this.buf, 0, 0, this.len);
    }

    public byte[] getByteCopy() {
        byte[] byArray = new byte[this.len];
        System.arraycopy(this.buf, 0, byArray, 0, this.len);
        return byArray;
    }

    public final byte[] getBytes() {
        return this.buf;
    }

    public final int length() {
        return this.len;
    }

    public final void reset() {
        this.len = 0;
    }

    public final void emit(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IOException("outputstream not existent");
        }
        outputStream.write(this.buf, 0, this.len);
    }

    HttpBuffer() {
        this.buf = new byte[128];
    }

    HttpBuffer(int n) {
        this.buf = new byte[n];
    }
}

