/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Vector;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpAcceptLanguage;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.ParseState;

public class HttpAcceptLanguageList
extends BasicValue {
    HttpAcceptLanguage[] languages = null;

    protected void parse() {
        Vector<HttpAcceptLanguage> vector = new Vector<HttpAcceptLanguage>(4);
        ParseState parseState = new ParseState(this.roff, this.rlen);
        parseState.separator = (byte)44;
        parseState.spaceIsSep = false;
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            vector.addElement(new HttpAcceptLanguage(this, this.raw, parseState.start, parseState.end));
            parseState.prepare();
        }
        this.languages = new HttpAcceptLanguage[vector.size()];
        vector.copyInto(this.languages);
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        if (this.languages == null) {
            for (int i = 0; i < this.languages.length; ++i) {
                if (i > 0) {
                    httpBuffer.append(',');
                }
                this.languages[i].appendValue(httpBuffer);
            }
            this.raw = httpBuffer.getByteCopy();
            this.roff = 0;
            this.rlen = this.raw.length;
        } else {
            this.raw = new byte[0];
            this.roff = 0;
            this.rlen = 0;
        }
    }

    public Object getValue() {
        this.validate();
        return this.languages;
    }

    public void addLanguage(HttpAcceptLanguage httpAcceptLanguage) {
        if (this.languages == null) {
            this.languages = new HttpAcceptLanguage[1];
            this.languages[0] = httpAcceptLanguage;
        } else {
            int n = this.languages.length;
            HttpAcceptLanguage[] httpAcceptLanguageArray = new HttpAcceptLanguage[n + 1];
            System.arraycopy(this.languages, 0, httpAcceptLanguageArray, 0, n);
            httpAcceptLanguageArray[n] = httpAcceptLanguage;
            this.languages = httpAcceptLanguageArray;
        }
    }

    HttpAcceptLanguageList() {
        this.isValid = false;
    }

    HttpAcceptLanguageList(HttpAcceptLanguage[] httpAcceptLanguageArray) {
        this.languages = httpAcceptLanguageArray;
        this.isValid = true;
    }
}

