/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XMLProperties
extends Properties {
    public static final String PARSER_P = "com.jclark.xml.sax.Driver";
    public boolean debug = false;
    private Class parser_class = null;

    public synchronized void load(InputStream inputStream) throws IOException {
        XMLParser xMLParser = null;
        try {
            xMLParser = new XMLParser(inputStream);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
    }

    public synchronized void load(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLParser xMLParser = null;
        try {
            xMLParser = new XMLParser(bufferedInputStream);
        }
        catch (SAXException sAXException) {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                super.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                throw new IOException(sAXException.getMessage());
            }
        }
    }

    public synchronized void save(OutputStream outputStream, String string) {
        try {
            this.store(outputStream, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("<?xml version='1.0'?>");
        if (string != null) {
            printWriter.println("<!--" + string + "-->");
        }
        printWriter.print("<properties>");
        Enumeration<Object> enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.get(string2);
            printWriter.print("\n <key name=\"" + string2 + "\">");
            printWriter.print(this.encode(string3));
            printWriter.print("</key>");
        }
        printWriter.print("\n</properties>");
        printWriter.flush();
    }

    protected StringBuffer encode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block5;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer;
    }

    private Class getParserClass() throws ClassNotFoundException {
        if (this.parser_class == null) {
            this.parser_class = Class.forName(PARSER_P);
        }
        return this.parser_class;
    }

    private Parser getParser() {
        try {
            return (Parser)this.getParserClass().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to intantiate : com.jclark.xml.sax.Driver");
        }
    }

    public XMLProperties() {
    }

    public XMLProperties(Properties properties) {
        super(properties);
    }

    public XMLProperties(String string, Properties properties) {
        super(properties);
        try {
            this.parser_class = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Unable to instanciate parser class: " + string);
            System.err.println("Using default parser.");
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    class XMLParser
    implements DocumentHandler {
        final int IN_NOTHING = 0;
        final int IN_DOCUMENT = 1;
        final int IN_KEY = 2;
        int state = 0;
        String key;
        StringBuffer value = new StringBuffer();
        Parser parser;

        XMLParser(InputStream inputStream) throws IOException, SAXException {
            try {
                this.parser = XMLProperties.this.getParser();
                this.parser.setDocumentHandler(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SAXException("can't create parser ");
            }
            this.parser.parse(new InputSource(inputStream));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String string, AttributeList attributeList) throws SAXException {
            if (this.state == 0) {
                if (!string.equals("properties")) throw new SAXException("attempt to find root properties");
                this.state = 1;
                return;
            } else {
                if (this.state != 1) throw new SAXException("invalid element " + string);
                if (!string.equals("key")) throw new SAXException("attempt to find keys");
                this.state = 2;
                this.key = attributeList.getValue("name");
                if (this.key != null) return;
                throw new SAXException("no name for key " + attributeList);
            }
        }

        public void endElement(String string) throws SAXException {
            if (this.state == 2) {
                XMLProperties.this.setProperty(this.key, this.value.toString());
                if (XMLProperties.this.debug) {
                    System.out.print("<key name=\"" + this.key + "\">");
                    System.out.println(this.value.toString() + "</key>\n");
                }
                this.state = 1;
                string = null;
                this.value = new StringBuffer();
            } else if (this.state == 1) {
                this.state = 0;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.state == 2) {
                this.compute(cArray, n, n2);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        private void compute(char[] cArray, int n, int n2) {
            int n3;
            int n4 = n2 - 1;
            for (n3 = n; n3 < n2 && (cArray[n3] == '\n' || cArray[n3] == '\t' || cArray[n3] == ' ' || cArray[n3] == '\r'); ++n3) {
            }
            while (n4 > 0 && (cArray[n4] == '\n' || cArray[n4] == '\t' || cArray[n4] == ' ' || cArray[n4] == '\r')) {
                --n4;
            }
            while (n3 <= n4) {
                this.value.append(cArray[n3]);
                ++n3;
            }
        }
    }
}

