/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import java.util.Date;

public class TimeFormatter {
    private static String[] fullWeekDays = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static String[] abrWeekDays = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] fullMonths = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static String[] abrMonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static String format(Date date, String string) {
        StringBuffer stringBuffer = new StringBuffer(50);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (++i == string.length()) break;
                c = string.charAt(i);
                if (c == 'E') {
                    ++i;
                } else if (c == 'Q') {
                    ++i;
                }
                if (i == string.length()) break;
                c = string.charAt(i);
                switch (c) {
                    case 'A': {
                        stringBuffer.append(fullWeekDays[date.getDay()]);
                        break;
                    }
                    case 'a': {
                        stringBuffer.append(abrWeekDays[date.getDay()]);
                        break;
                    }
                    case 'B': {
                        stringBuffer.append(fullMonths[date.getMonth()]);
                        break;
                    }
                    case 'b': 
                    case 'h': {
                        stringBuffer.append(abrMonths[date.getMonth()]);
                        break;
                    }
                    case 'C': {
                        TimeFormatter.appendPadded(stringBuffer, (date.getYear() + 1900) / 100, 2);
                        break;
                    }
                    case 'c': {
                        stringBuffer.append(date.toLocaleString());
                        break;
                    }
                    case 'D': {
                        stringBuffer.append(TimeFormatter.format(date, "%m/%d/%y"));
                        break;
                    }
                    case 'd': {
                        TimeFormatter.appendPadded(stringBuffer, date.getDate(), 2);
                        break;
                    }
                    case 'e': {
                        TimeFormatter.appendPadded(stringBuffer, date.getMonth() + 1, 2, ' ');
                        break;
                    }
                    case 'H': {
                        TimeFormatter.appendPadded(stringBuffer, date.getHours(), 2);
                        break;
                    }
                    case 'I': 
                    case 'l': {
                        int n = date.getHours() % 12;
                        if (n == 0) {
                            n = 12;
                        }
                        TimeFormatter.appendPadded(stringBuffer, n, 2, c == 'I' ? (char)'0' : ' ');
                        break;
                    }
                    case 'j': {
                        stringBuffer.append("[?]");
                        break;
                    }
                    case 'k': {
                        TimeFormatter.appendPadded(stringBuffer, date.getHours(), 2, ' ');
                        break;
                    }
                    case 'M': {
                        TimeFormatter.appendPadded(stringBuffer, date.getMinutes(), 2);
                        break;
                    }
                    case 'm': {
                        TimeFormatter.appendPadded(stringBuffer, date.getMonth() + 1, 2);
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'p': {
                        stringBuffer.append(date.getHours() < 12 ? "am" : "pm");
                        break;
                    }
                    case 'R': {
                        stringBuffer.append(TimeFormatter.format(date, "%H:%M"));
                        break;
                    }
                    case 'r': {
                        stringBuffer.append(TimeFormatter.format(date, "%l:%M%p"));
                        break;
                    }
                    case 'S': {
                        TimeFormatter.appendPadded(stringBuffer, date.getSeconds(), 2);
                        break;
                    }
                    case 'T': {
                        stringBuffer.append(TimeFormatter.format(date, "%H:%M:%S"));
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'u': {
                        stringBuffer.append("[?]");
                        break;
                    }
                    case 'w': {
                        stringBuffer.append(date.getDay());
                        break;
                    }
                    case 'X': {
                        stringBuffer.append(TimeFormatter.format(date, "%H:%M:%S"));
                        break;
                    }
                    case 'x': {
                        stringBuffer.append(TimeFormatter.format(date, "%B %e, %Y"));
                        break;
                    }
                    case 'y': {
                        TimeFormatter.appendPadded(stringBuffer, (date.getYear() + 1900) % 100, 2);
                        break;
                    }
                    case 'Y': {
                        TimeFormatter.appendPadded(stringBuffer, date.getYear() + 1900, 4);
                        break;
                    }
                    case 'Z': {
                        String string2 = date.toString();
                        stringBuffer.append(string2.substring(20, 23));
                        break;
                    }
                    case '%': {
                        stringBuffer.append('%');
                    }
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static void appendPadded(StringBuffer stringBuffer, int n, int n2, char c) {
        String string = String.valueOf(n).trim();
        for (int i = 0; i < n2 - string.length(); ++i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
    }

    private static final void appendPadded(StringBuffer stringBuffer, int n, int n2) {
        TimeFormatter.appendPadded(stringBuffer, n, n2, '0');
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(TimeFormatter.format(new Date(), stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

