/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.widgets;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.w3c.tools.widgets.ImageCache;
import org.w3c.tools.widgets.NodeHandler;
import org.w3c.tools.widgets.TreeNode;

public class TreeBrowser
extends Canvas
implements AdjustmentListener {
    public static final int SCROLLBARS_ALWAYS = 0;
    public static final int SCROLLBARS_ASNEEDED = 1;
    public static final int SINGLE = 0;
    public static final int MULTIPLE = 1;
    static final int HMARGIN = 5;
    static final int VMARGIN = 5;
    static final int HGAP = 10;
    static final int DXLEVEL = 20;
    private Scrollbar vscroll;
    private Scrollbar hscroll;
    private int maxwidth = 0;
    private int startx = 0;
    private Color selectColor = new Color(0, 0, 128);
    private Color selectFontColor = Color.white;
    private int scrollbarDisplayPolicy = 1;
    private boolean hierarchyChanged = true;
    protected Vector items;
    protected Vector selection = new Vector(1, 1);
    protected int topItem = 0;
    protected int visibleItemCount = 20;
    protected int selectionPolicy = 0;
    protected int fontHeight;

    public TreeBrowser(Object object, String string, NodeHandler nodeHandler, Image image) {
        this();
        this.initialize(object, string, nodeHandler, image);
    }

    protected TreeBrowser() {
        this.items = new Vector();
        this.addMouseListener(new BrowserMouseListener());
    }

    protected void initialize(Object object, String string, NodeHandler nodeHandler, Image image) {
        this.items.addElement(new TreeNode(object, string, nodeHandler, image, 0));
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 400);
    }

    public void setSelectionFontColor(Color color) {
        this.selectFontColor = color;
    }

    public void setSelectionBackgroudColor(Color color) {
        this.selectColor = color;
    }

    public void setScrollbarDisplayPolicy(int n) {
        this.scrollbarDisplayPolicy = n;
        this.hierarchyChanged = false;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        TreeNode treeNode;
        int n5;
        this.fontHeight = graphics.getFontMetrics().getHeight();
        int n6 = graphics.getFontMetrics().getAscent();
        int n7 = this.items.size();
        Dimension dimension = this.getSize();
        int n8 = dimension.height - 10;
        int n9 = dimension.width - 10;
        graphics.clipRect(5, 5, n9, n8);
        graphics.translate(5, 5);
        int n10 = 0;
        Stack<Integer> stack = new Stack<Integer>();
        Graphics graphics2 = graphics.create();
        graphics2.setColor(this.selectColor);
        graphics.setFont(this.getFont());
        this.visibleItemCount = 0;
        int n11 = -1;
        if (this.hierarchyChanged) {
            this.maxwidth = 0;
        }
        for (n5 = 0; n5 < this.topItem; ++n5) {
            treeNode = (TreeNode)this.items.elementAt(n5);
            if (this.hierarchyChanged) {
                n4 = treeNode.level * 20;
                n3 = graphics.getFontMetrics().stringWidth(treeNode.label);
                this.maxwidth = Math.max(this.maxwidth, n4 + 20 + n3);
            }
            if (treeNode.level > n11) {
                stack.push(new Integer(n5 - 1));
                n11 = treeNode.level;
            }
            if (treeNode.level >= n11) continue;
            for (n2 = treeNode.level; n2 < n11; ++n2) {
                stack.pop();
            }
            n11 = treeNode.level;
        }
        n2 = n7 - this.topItem;
        n5 = n8 / this.fontHeight;
        if (n2 < n5) {
            this.topItem = Math.max(0, this.topItem - (n5 - n2));
        }
        if (n9 >= this.maxwidth) {
            this.startx = 0;
        } else if (this.startx + n9 > this.maxwidth) {
            this.startx = this.maxwidth - n9;
        }
        for (n = this.topItem; n < n7; ++n) {
            int n12;
            int n13;
            treeNode = (TreeNode)this.items.elementAt(n);
            if (treeNode.level > n11) {
                stack.push(new Integer(n - 1));
                n11 = treeNode.level;
            }
            if (treeNode.level < n11) {
                for (n13 = treeNode.level; n13 < n11; ++n13) {
                    stack.pop();
                }
                n11 = treeNode.level;
            }
            n4 = treeNode.level * 20 - this.startx;
            if (n10 <= n8) {
                if (treeNode.selected) {
                    graphics2.fillRect(n4, n10 - 1, Math.max(n9 - 1, this.maxwidth - 1), this.fontHeight);
                    graphics.setColor(this.selectFontColor);
                    graphics.drawImage(treeNode.icon, n4, n10, this);
                    graphics.drawString(treeNode.label, n4 + 20, n10 + n6);
                    graphics.setColor(this.getForeground());
                } else {
                    graphics.setColor(this.getForeground());
                    graphics.drawImage(treeNode.icon, n4, n10, this);
                    graphics.drawString(treeNode.label, n4 + 20, n10 + n6);
                }
                n12 = (Integer)stack.peek();
                if (n12 != -1) {
                    n13 = n12 - this.topItem;
                    graphics.drawLine(n4 - 5, n10 + this.fontHeight / 2, n4 - 20 + 5, n10 + this.fontHeight / 2);
                    if (treeNode.handler.isDirectory(this, treeNode)) {
                        graphics.drawRect(n4 - 20 + 5 - 2, n10 + this.fontHeight / 2 - 2, 4, 4);
                    }
                    graphics.drawLine(n4 - 20 + 5, n10 + this.fontHeight / 2, n4 - 20 + 5, (n13 + 1) * this.fontHeight - 1);
                }
                ++this.visibleItemCount;
            } else {
                n12 = (Integer)stack.peek();
                if (n12 != -1 && ((n13 = n12 - this.topItem) + 1) * this.fontHeight - 1 < n8) {
                    graphics.drawLine(n4 - 20 + 5, n8 - 1, n4 - 20 + 5, (n13 + 1) * this.fontHeight - 1);
                }
            }
            if (this.hierarchyChanged) {
                n4 = treeNode.level * 20;
                n3 = graphics.getFontMetrics().stringWidth(treeNode.label);
                this.maxwidth = Math.max(this.maxwidth, n4 + 20 + n3);
            }
            n10 += this.fontHeight;
        }
        if (this.hierarchyChanged) {
            for (n = n7; n < this.items.size(); ++n) {
                treeNode = (TreeNode)this.items.elementAt(n);
                n4 = treeNode.level * 20;
                n3 = graphics.getFontMetrics().stringWidth(treeNode.label);
                this.maxwidth = Math.max(this.maxwidth, n4 + 20 + n3);
            }
        }
        this.hierarchyChanged = false;
        this.updateScrollbars();
    }

    protected TreeNode itemAt(int n) {
        for (int i = this.topItem; i < this.items.size() && n > 0; n -= this.fontHeight, ++i) {
            if (n >= this.fontHeight) continue;
            return (TreeNode)this.items.elementAt(i);
        }
        return null;
    }

    public void update(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Image image = null;
        Dimension dimension = this.getSize();
        image = ImageCache.getImage(this, dimension.width, dimension.height);
        Graphics graphics2 = image.getGraphics();
        if (rectangle != null) {
            graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(this.getForeground());
        this.paint(graphics2);
        graphics.drawImage(image, 0, 0, this);
    }

    public void insert(TreeNode treeNode, Object object, NodeHandler nodeHandler, String string, Image image) {
        int n;
        if (treeNode == null) {
            throw new IllegalArgumentException("null parent");
        }
        if (nodeHandler == null && string == null) {
            throw new IllegalArgumentException("non-null item required");
        }
        if (nodeHandler == null) {
            nodeHandler = treeNode.handler;
        }
        if (string == null) {
            string = nodeHandler.toString();
        }
        treeNode.children = treeNode.children == -1 ? 1 : ++treeNode.children;
        boolean bl = false;
        TreeNode treeNode2 = null;
        for (n = this.items.indexOf(treeNode) + treeNode.children; n < this.items.size() && ((TreeNode)this.items.elementAt((int)n)).level > treeNode.level; ++n) {
        }
        treeNode2 = new TreeNode(object, string, nodeHandler, image, treeNode.level + 1);
        this.items.insertElementAt(treeNode2, n);
        this.hierarchyChanged = true;
    }

    public void remove(TreeNode treeNode) {
        TreeNode treeNode2 = null;
        for (int i = this.items.indexOf(treeNode); i >= 0; --i) {
            treeNode2 = (TreeNode)this.items.elementAt(i);
            if (treeNode2.level >= treeNode.level) {
                continue;
            }
            --treeNode2.children;
            break;
        }
        this.items.removeElement(treeNode);
        if (treeNode.selected) {
            this.unselect(treeNode);
        }
        this.hierarchyChanged = true;
    }

    public void removeBranch(TreeNode treeNode) {
        int n = this.items.indexOf(treeNode) + 1;
        int n2 = this.items.size() - 1;
        for (int i = n; i < n2 && ((TreeNode)this.items.elementAt((int)n)).level > treeNode.level; ++i) {
            this.remove((TreeNode)this.items.elementAt(n));
        }
        this.remove(treeNode);
        this.hierarchyChanged = true;
    }

    public synchronized void collapse(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode;
        if (treeNode2.children != -1) {
            treeNode2.children = -1;
            int n = this.items.indexOf(treeNode) + 1;
            while (n < this.items.size()) {
                TreeNode treeNode3 = (TreeNode)this.items.elementAt(n);
                if (treeNode3.level > treeNode2.level) {
                    this.items.removeElementAt(n);
                    if (!treeNode3.selected) continue;
                    this.unselect(treeNode3);
                    continue;
                }
                this.hierarchyChanged = true;
                return;
            }
        }
    }

    public void setSelectionPolicy(int n) {
        this.selectionPolicy = n;
    }

    public int getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public void select(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        if (this.selectionPolicy == 0) {
            this.unselectAll();
        }
        this.selection.addElement(treeNode);
        treeNode.selected = true;
    }

    public void unselect(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        this.selection.removeElement(treeNode);
        treeNode.selected = false;
    }

    public void unselectAll() {
        Enumeration enumeration = this.selection.elements();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = (TreeNode)enumeration.nextElement();
            treeNode.selected = false;
        }
    }

    public Enumeration selection() {
        return this.selection.elements();
    }

    private void updateScrollbars() {
        int n = this.items.size() + 1;
        if (this.items.size() > this.visibleItemCount) {
            this.vscroll.setMaximum(n);
            this.vscroll.setVisibleAmount(this.visibleItemCount);
            this.vscroll.setVisible(true);
        } else {
            this.vscroll.setValue(0);
            this.vscroll.setMaximum(n);
            this.vscroll.setVisibleAmount(n);
            if (this.scrollbarDisplayPolicy == 1) {
                this.vscroll.setVisible(false);
            }
        }
        int n2 = this.getSize().width - 10;
        this.hscroll.setMaximum(this.maxwidth);
        this.hscroll.setVisibleAmount(n2);
        if (this.maxwidth > n2) {
            this.hscroll.setVisible(true);
        } else if (this.scrollbarDisplayPolicy == 1) {
            this.hscroll.setVisible(false);
        }
    }

    public void setVerticalScrollbar(Scrollbar scrollbar) {
        this.vscroll = scrollbar;
        this.vscroll.addAdjustmentListener(this);
        this.vscroll.setMaximum(this.visibleItemCount);
        this.vscroll.setVisibleAmount(this.visibleItemCount);
        this.vscroll.setBlockIncrement(this.visibleItemCount);
    }

    public void setHorizontalScrollbar(Scrollbar scrollbar) {
        this.hscroll = scrollbar;
        this.hscroll.addAdjustmentListener(this);
        int n = this.getSize().width - 10;
        this.hscroll.setMaximum(n);
        this.hscroll.setVisibleAmount(n);
        this.hscroll.setBlockIncrement(20);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.vscroll) {
            this.topItem = adjustmentEvent.getValue();
        } else {
            this.startx = adjustmentEvent.getValue();
        }
        this.repaint();
    }

    public TreeNode getParent(TreeNode treeNode) {
        int n = this.items.indexOf(treeNode);
        for (int i = n - 1; i >= 0; --i) {
            TreeNode treeNode2 = (TreeNode)this.items.elementAt(i);
            if (treeNode2.level >= treeNode.level) continue;
            return treeNode2;
        }
        return null;
    }

    public TreeNode getNode(Object object) {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            if (!object.equals(((TreeNode)this.items.elementAt(i)).getItem())) continue;
            return (TreeNode)this.items.elementAt(i);
        }
        return null;
    }

    private class BrowserMouseListener
    extends MouseAdapter {
        private BrowserMouseListener() {
        }

        private void clickAt(TreeNode treeNode, MouseEvent mouseEvent) {
            if (treeNode == null) {
                return;
            }
            int n = mouseEvent.getX() - 5;
            if (treeNode.handler == null) {
                return;
            }
            if (n >= treeNode.level * 20 && n <= treeNode.level * 20 + 20) {
                if (treeNode.children != -1) {
                    treeNode.handler.notifyCollapse(TreeBrowser.this, treeNode);
                } else {
                    treeNode.handler.notifyExpand(TreeBrowser.this, treeNode);
                }
            } else if (n > treeNode.level * 20 + 10) {
                treeNode.handler.notifySelect(TreeBrowser.this, treeNode);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getY() - 5;
            if (mouseEvent.getClickCount() == 1) {
                this.clickAt(TreeBrowser.this.itemAt(n), mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            TreeNode treeNode;
            if (mouseEvent.getClickCount() > 1 && (treeNode = TreeBrowser.this.itemAt(n = mouseEvent.getY() - 5)) != null && treeNode.handler != null) {
                treeNode.handler.notifyExecute(TreeBrowser.this, treeNode);
            }
        }
    }
}

