/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.ssi;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.w3c.jigsaw.http.ClientException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.ssi.Segment;
import org.w3c.jigsaw.ssi.SegmentInputStream;
import org.w3c.jigsaw.ssi.commands.ControlCommandException;

class SSIStream
extends FilterInputStream {
    private Segment[] segments;
    private Reply[] replies;
    private RandomAccessFile file;
    private int curSeg = 0;
    protected boolean cacheValid = true;

    private boolean nextSegment() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (this.curSeg < this.segments.length) {
            Segment segment = this.segments[this.curSeg];
            if (segment.isControl()) {
                try {
                    this.curSeg = this.segments[this.curSeg].jumpTo();
                    continue;
                }
                catch (ControlCommandException controlCommandException) {
                    System.out.println(controlCommandException.getMessage());
                    controlCommandException.printStackTrace();
                    return false;
                }
            }
            if (!segment.isUnparsed()) {
                if (!this.cacheValid) {
                    this.replies[this.curSeg] = this.segments[this.curSeg].get();
                } else if (this.segments[this.curSeg].needsRevalidate()) {
                    this.replies[this.curSeg] = this.segments[this.curSeg].get();
                }
                if (this.replies[this.curSeg] != null) {
                    this.in = this.replies[this.curSeg].openStream();
                    if (this.in != null) {
                        ++this.curSeg;
                        return true;
                    }
                }
                ++this.curSeg;
                continue;
            }
            try {
                this.in = new SegmentInputStream(this.file, segment.start, segment.end - segment.start);
                ++this.curSeg;
                return true;
            }
            catch (IOException iOException) {
            }
        }
        this.in = null;
        return false;
    }

    public SSIStream(boolean bl, Segment[] segmentArray, Reply[] replyArray, RandomAccessFile randomAccessFile) throws IOException, ClientException {
        super(null);
        this.segments = segmentArray;
        this.replies = replyArray;
        this.file = randomAccessFile;
        this.cacheValid = bl;
        this.nextSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int n = -1;
        try {
            n = this.in.read();
            return n;
        }
        catch (IOException iOException) {
            n = -1;
            return n;
        }
        finally {
            if (n != -1) {
                return n;
            }
            if (!this.nextSegment()) {
                return -1;
            }
            return this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        try {
            n3 = this.in.read(byArray, n, n2);
            return n3;
        }
        catch (IOException iOException) {
            n3 = -1;
            return n3;
        }
        finally {
            if (n3 != -1) {
                return n3;
            }
            if (!this.nextSegment()) {
                return -1;
            }
            return this.read(byArray, n, n2);
        }
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.file.close();
    }

    public synchronized void mark() {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark not supported");
    }

    public boolean markSupported() {
        return false;
    }
}

