/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.https.socket;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidParameterSpecException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.http.socket.SocketClient;
import org.w3c.jigsaw.http.socket.SocketClientFactory;
import org.w3c.jigsaw.http.socket.SocketClientState;
import org.w3c.jigsaw.https.SSLAdapter;
import org.w3c.jigsaw.https.socket.SSLProperties;
import org.w3c.jigsaw.https.socket.SSLSocketClient;
import org.w3c.util.ObservableProperties;

public class SSLSocketClientFactory
extends SocketClientFactory {
    private static final boolean supportsOptionalClientAuth;
    private static final String implementationNamespace;
    public static final String PROTOCOL_HANDLER_S = "java.protocol.handler.pkgs";
    private static boolean debug;
    private SSLContext context = null;
    private httpd daemon = null;
    private InetAddress bindAddr = null;
    private int maxClients = 0;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$security$KeyStore;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$security$SecureRandom;
    static /* synthetic */ Class class$javax$net$ssl$SSLServerSocket;

    public ServerSocket createServerSocket() throws IOException {
        int n = this.daemon.getPort();
        int n2 = Math.max(128, this.maxClients);
        ServerSocket serverSocket = null;
        serverSocket = this.bindAddr == null ? this.getFactory().createServerSocket(n, n2) : this.getFactory().createServerSocket(n, n2, this.bindAddr);
        if (serverSocket instanceof SSLServerSocket) {
            boolean bl;
            ObservableProperties observableProperties = this.daemon.getProperties();
            boolean bl2 = observableProperties.getBoolean("org.w3c.jigsaw.ssl.must.authenticate", false);
            boolean bl3 = observableProperties.getBoolean("org.w3c.jigsaw.ssl.truststore.generic", false);
            String string = observableProperties.getString("org.w3c.jigsaw.ssl.truststore.path", null);
            boolean bl4 = bl = bl2 || bl3 || null != string && string.length() > 0;
            if (bl) {
                SSLServerSocket sSLServerSocket = (SSLServerSocket)serverSocket;
                if (bl2) {
                    sSLServerSocket.setNeedClientAuth(true);
                } else if (supportsOptionalClientAuth) {
                    sSLServerSocket.setWantClientAuth(true);
                } else {
                    throw new SSLProtocolException("Optional client authentication not supported by the current api level. Consider upgrading your api or using obligatory client authentication or using server authentication only");
                }
            }
        }
        return serverSocket;
    }

    private static final void addProvider(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (null != string && null == Security.getProvider(string)) {
            Class<?> clazz = Class.forName(string);
            Provider provider = (Provider)clazz.newInstance();
            Security.addProvider(provider);
            if (debug) {
                System.out.println("Added new security provider: " + provider.getInfo() + ".");
            }
        }
    }

    private static final void setHandler(String string) {
        if (null != string) {
            System.setProperty(PROTOCOL_HANDLER_S, string);
            if (debug) {
                System.out.println("Set new protocol handler: " + string + ".");
            }
        }
    }

    private static final KeyStore getStore(ObservableProperties observableProperties, String string, String string2, String string3) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        String string4 = observableProperties.getString(string2, null);
        if (null != string4 && "".equals(string4.trim())) {
            string4 = null;
        }
        String string5 = observableProperties.getString(string3, null);
        if (null != string4 || null != string5) {
            String string6 = observableProperties.getString(string, KeyStore.getDefaultType());
            KeyStore keyStore = KeyStore.getInstance(string6);
            keyStore.load(null != string4 ? new BufferedInputStream(new FileInputStream(string4)) : null, null != string5 ? string5.toCharArray() : new char[]{});
            return keyStore;
        }
        return null;
    }

    private static final Object getParams(ObservableProperties observableProperties, String string, String string2, String string3) throws InvalidParameterSpecException, InvalidAlgorithmParameterException, ClassNotFoundException {
        if (supportsOptionalClientAuth) {
            String string4 = observableProperties.getString(string, null);
            if (null != string4 && string4.length() > 0) {
                Class<?> clazz = Class.forName(string4);
                String string5 = observableProperties.getString(string2, null);
                String string6 = observableProperties.getString(string3, null);
                ManagerFactoryParametersFactory managerFactoryParametersFactory = new ManagerFactoryParametersFactory((Object)clazz);
                Object object = null;
                try {
                    object = managerFactoryParametersFactory.getInstance(string5, string6);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        object = managerFactoryParametersFactory.getInstance(string5);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            object = managerFactoryParametersFactory.getInstance();
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            throw new InvalidAlgorithmParameterException("Factory specified by type property has no suitable instantiation method");
                        }
                    }
                }
                Class<?> clazz2 = Class.forName(implementationNamespace + "ManagerFactoryParameters");
                if (clazz2.isInstance(object)) {
                    return new Delegator(object, clazz2);
                }
                throw new InvalidAlgorithmParameterException("Factory specified by type property does not supply manager factory parameters");
            }
            throw new InvalidAlgorithmParameterException("No manager factory parameter class specified as the type property");
        }
        throw new InvalidParameterSpecException("Generic manager factory parameters not supported by the current api level. Consider upgrading your api or using a classic keystore");
    }

    private static final SSLContext createContext(ObservableProperties observableProperties) throws ClassNotFoundException, KeyStoreException, IOException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException, CertificateException, UnrecoverableKeyException, InstantiationException, IllegalAccessException, InvocationTargetException, KeyManagementException {
        Object object;
        String string;
        Object object2;
        Class<?> clazz = Class.forName(implementationNamespace + "KeyManagerFactory");
        Class<?> clazz2 = Class.forName(implementationNamespace + "TrustManagerFactory");
        Class<?> clazz3 = Class.forName(implementationNamespace + "SSLContext");
        KeyManagerFactory keyManagerFactory = new KeyManagerFactory((Object)clazz);
        String string2 = observableProperties.getString("org.w3c.jigsaw.ssl.keymanager.type", null);
        Object object3 = keyManagerFactory.getInstance(null != string2 ? string2 : keyManagerFactory.getDefaultAlgorithm());
        KeyManagerFactory keyManagerFactory2 = new KeyManagerFactory(object3);
        boolean bl = observableProperties.getBoolean("org.w3c.jigsaw.ssl.keystore.generic", false);
        if (bl) {
            object2 = SSLSocketClientFactory.getParams(observableProperties, "org.w3c.jigsaw.ssl.truststore.type", "org.w3c.jigsaw.ssl.truststore.path", "org.w3c.jigsaw.ssl.truststore.password");
            keyManagerFactory2.init(object2);
        } else {
            object2 = SSLSocketClientFactory.getStore(observableProperties, "org.w3c.jigsaw.ssl.keystore.type", "org.w3c.jigsaw.ssl.keystore.path", "org.w3c.jigsaw.ssl.keystore.password");
            string = observableProperties.getString("org.w3c.jigsaw.ssl.keystore.password", null);
            keyManagerFactory2.init((KeyStore)object2, null != string ? string.toCharArray() : new char[]{});
        }
        object2 = new TrustManagerFactory((Object)clazz2);
        string = observableProperties.getString("org.w3c.jigsaw.ssl.trustmanager.type", null);
        Object object4 = ((TrustManagerFactory)object2).getInstance(null != string ? string : ((TrustManagerFactory)object2).getDefaultAlgorithm());
        TrustManagerFactory trustManagerFactory = new TrustManagerFactory(object4);
        boolean bl2 = observableProperties.getBoolean("org.w3c.jigsaw.ssl.truststore.generic", false);
        if (bl2) {
            object = SSLSocketClientFactory.getParams(observableProperties, "org.w3c.jigsaw.ssl.truststore.type", "org.w3c.jigsaw.ssl.truststore.path", "org.w3c.jigsaw.ssl.truststore.password");
            trustManagerFactory.init(object);
        } else {
            object = SSLSocketClientFactory.getStore(observableProperties, "org.w3c.jigsaw.ssl.truststore.type", "org.w3c.jigsaw.ssl.truststore.path", "org.w3c.jigsaw.ssl.truststore.password");
            trustManagerFactory.init((KeyStore)object);
        }
        object = observableProperties.getString("org.w3c.jigsaw.ssl.protocol.name", "TLS");
        SSLContext sSLContext = new SSLContext((Object)clazz3);
        Object object5 = sSLContext.getInstance((String)object);
        SSLContext sSLContext2 = new SSLContext(object5);
        sSLContext2.init(keyManagerFactory2.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return sSLContext2;
    }

    public void initialize(httpd httpd2) {
        super.initialize(httpd2);
        this.daemon = httpd2;
        this.daemon.registerPropertySet(new SSLProperties(this.daemon));
        ObservableProperties observableProperties = this.daemon.getProperties();
        try {
            String string = observableProperties.getString("org.w3c.jigsaw.ssl.security.provider", supportsOptionalClientAuth ? null : "com.sun.net.ssl.internal.ssl.Provider");
            SSLSocketClientFactory.addProvider(string);
            String string2 = observableProperties.getString("org.w3c.jigsaw.ssl.protocol.handler", supportsOptionalClientAuth ? null : "com.sun.net.ssl.internal.www.protocol");
            SSLSocketClientFactory.setHandler(string2);
            this.context = SSLSocketClientFactory.createContext(observableProperties);
            String string3 = observableProperties.getString("org.w3c.jigsaw.http.socket.SocketClientFactory.bindAddress", null);
            if (string3 != null) {
                try {
                    this.bindAddr = InetAddress.getByName(string3);
                }
                catch (Exception exception) {
                    this.bindAddr = null;
                }
            } else {
                this.bindAddr = null;
            }
            this.maxClients = observableProperties.getInteger("org.w3c.jigsaw.http.socket.SocketClientFactory.maxClients", 32);
        }
        catch (Exception exception) {
            String string = "Unable to initialize secure socket provider";
            this.daemon.fatal(exception, string);
            if (debug) {
                System.err.println(string);
                exception.printStackTrace();
            }
            RuntimeException runtimeException = new RuntimeException(string);
            SSLAdapter.fillInStackTrace(runtimeException, exception);
            throw runtimeException;
        }
    }

    public boolean propertyChanged(String string) {
        if (super.propertyChanged(string)) {
            ObservableProperties observableProperties = this.daemon.getProperties();
            try {
                if (string.equals("org.w3c.jigsaw.http.socket.SocketClientFactory.maxClients")) {
                    int n = observableProperties.getInteger("org.w3c.jigsaw.http.socket.SocketClientFactory.maxClients", -1);
                    if (n > this.maxClients) {
                        int n2 = this.maxClients - n;
                        while (--n2 >= 0) {
                            this.addClient(true);
                        }
                    } else if (n > 0) {
                        this.maxClients = n;
                    }
                    return true;
                }
                if (string.equals("org.w3c.jigsaw.http.socket.SocketClientFactory.bindAddress")) {
                    this.bindAddr = InetAddress.getByName(observableProperties.getString("org.w3c.jigsaw.http.socket.SocketClientFactory.bindAddress", null));
                    return true;
                }
                if (string.equals("org.w3c.jigsaw.ssl.keystore.generic") || string.equals("org.w3c.jigsaw.ssl.keystore.path") || string.equals("org.w3c.jigsaw.ssl.keystore.type") || string.equals("org.w3c.jigsaw.ssl.keystore.password") || string.equals("org.w3c.jigsaw.ssl.truststore.generic") || string.equals("org.w3c.jigsaw.ssl.truststore.path") || string.equals("org.w3c.jigsaw.ssl.truststore.type") || string.equals("org.w3c.jigsaw.ssl.truststore.password") || string.equals("org.w3c.jigsaw.ssl.protocol.name")) {
                    this.context = SSLSocketClientFactory.createContext(observableProperties);
                    return true;
                }
                return true;
            }
            catch (Exception exception) {
                String string2 = "Unable to re-initialize secure socket provider";
                this.daemon.fatal(exception, string2);
                if (debug) {
                    System.err.println(string2);
                    exception.printStackTrace();
                }
                return false;
            }
        }
        return false;
    }

    private ServerSocketFactory getFactory() throws SSLKeyException {
        String[] stringArray;
        ServerSocketFactory serverSocketFactory = null != this.context ? this.context.getServerSocketFactory() : SSLServerSocketFactory.getDefault();
        String[] stringArray2 = ((SSLServerSocketFactory)serverSocketFactory).getSupportedCipherSuites();
        if (debug) {
            System.out.println("Supported suites:");
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println("          " + stringArray2[i]);
            }
            stringArray = ((SSLServerSocketFactory)serverSocketFactory).getDefaultCipherSuites();
            System.out.println("Enabled suites:");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("         " + stringArray[i]);
            }
        }
        if (stringArray2.length < 1) {
            stringArray = new SSLKeyException("No cipher suites supported by this SSL socket factory. Please check your factory, key store, store password and cerificates");
            this.daemon.fatal((Exception)stringArray, stringArray.getMessage());
            if (debug) {
                stringArray.printStackTrace();
            }
            throw stringArray;
        }
        return serverSocketFactory;
    }

    protected SocketClient createClient(httpd httpd2, SocketClientState socketClientState) {
        return new SSLSocketClient(httpd2, this, socketClientState);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        boolean bl = false;
        try {
            Class clazz = class$javax$net$ssl$SSLServerSocket == null ? (class$javax$net$ssl$SSLServerSocket = SSLSocketClientFactory.class$("javax.net.ssl.SSLServerSocket")) : class$javax$net$ssl$SSLServerSocket;
            Class[] classArray = new Class[]{Boolean.TYPE};
            Object var3_4 = null;
            supportsOptionalClientAuth = bl = null != clazz.getMethod("setWantClientAuth", classArray);
            implementationNamespace = bl ? "javax.net.ssl." : "com.sun.net.ssl.";
        }
        catch (Exception exception) {
            try {
                supportsOptionalClientAuth = bl = false;
                implementationNamespace = bl ? "javax.net.ssl." : "com.sun.net.ssl.";
            }
            catch (Throwable throwable) {
                supportsOptionalClientAuth = bl;
                implementationNamespace = bl ? "javax.net.ssl." : "com.sun.net.ssl.";
                throw throwable;
            }
        }
        debug = false;
    }

    private static class Delegator {
        private final Class facade;
        private final Class type;
        private final Object peer;

        public Delegator(Object object, Class clazz) {
            if (object instanceof Class) {
                this.type = (Class)object;
                this.peer = null;
            } else {
                this.type = object.getClass();
                this.peer = object;
            }
            this.facade = clazz;
        }

        public Delegator(Object object) {
            this(object, null);
        }

        public Object invoke(String string, Class[] classArray, Object[] objectArray) throws Exception {
            int n = objectArray != null ? objectArray.length : 0;
            Class[] classArray2 = new Class[n];
            Object[] objectArray2 = new Object[n];
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                Class clazz = null;
                if (null != object) {
                    clazz = object.getClass();
                    if (object instanceof Delegator) {
                        Delegator delegator = (Delegator)object;
                        object = delegator.peer;
                        if (null != delegator.facade) {
                            clazz = delegator.facade;
                        }
                    }
                }
                classArray2[i] = null != clazz ? clazz : (null != classArray && i < classArray.length ? classArray[i] : (class$java$lang$Object == null ? SSLSocketClientFactory.class$("java.lang.Object") : class$java$lang$Object));
                objectArray2[i] = object;
            }
            Method method = this.type.getMethod(string, classArray2);
            return method.invoke(this.peer, objectArray2);
        }
    }

    private static final class ManagerFactoryParametersFactory
    extends Delegator {
        private ManagerFactoryParametersFactory(Object object) {
            super(object);
        }

        public Object getInstance(String string, String string2) throws InvalidAlgorithmParameterException, NoSuchMethodException {
            try {
                return this.invoke("getInstance", new Class[]{class$java$lang$String == null ? (class$java$lang$String = SSLSocketClientFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SSLSocketClientFactory.class$("java.lang.String")) : class$java$lang$String}, new Object[]{string, string2});
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw invalidAlgorithmParameterException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw noSuchMethodException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public Object getInstance(String string) throws InvalidAlgorithmParameterException, NoSuchMethodException {
            try {
                return this.invoke("getInstance", new Class[]{class$java$lang$String == null ? (class$java$lang$String = SSLSocketClientFactory.class$("java.lang.String")) : class$java$lang$String}, new Object[]{string});
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw invalidAlgorithmParameterException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw noSuchMethodException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public Object getInstance() throws InvalidAlgorithmParameterException, NoSuchMethodException {
            try {
                return this.invoke("getInstance", null, null);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw invalidAlgorithmParameterException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw noSuchMethodException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }
    }

    private static final class SSLContext
    extends Delegator {
        private SSLContext(Object object) {
            super(object);
        }

        public Object getInstance(String string) throws NoSuchAlgorithmException {
            try {
                return this.invoke("getInstance", new Class[]{class$java$lang$String == null ? (class$java$lang$String = SSLSocketClientFactory.class$("java.lang.String")) : class$java$lang$String}, new Object[]{string});
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public void init(Object object, Object object2, SecureRandom secureRandom) throws KeyManagementException {
            try {
                this.invoke("init", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = SSLSocketClientFactory.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = SSLSocketClientFactory.class$("java.lang.Object")) : class$java$lang$Object, class$java$security$SecureRandom == null ? (class$java$security$SecureRandom = SSLSocketClientFactory.class$("java.security.SecureRandom")) : class$java$security$SecureRandom}, new Object[]{object, object2, secureRandom});
            }
            catch (KeyManagementException keyManagementException) {
                throw keyManagementException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public SSLServerSocketFactory getServerSocketFactory() {
            try {
                return (SSLServerSocketFactory)this.invoke("getServerSocketFactory", null, null);
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }
    }

    private static final class TrustManagerFactory
    extends Delegator {
        private TrustManagerFactory(Object object) {
            super(object);
        }

        public String getDefaultAlgorithm() {
            try {
                return (String)this.invoke("getDefaultAlgorithm", null, null);
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public Object getInstance(String string) throws NoSuchAlgorithmException {
            try {
                return this.invoke("getInstance", new Class[]{class$java$lang$String == null ? (class$java$lang$String = SSLSocketClientFactory.class$("java.lang.String")) : class$java$lang$String}, new Object[]{string});
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public void init(KeyStore keyStore) throws KeyStoreException {
            try {
                this.invoke("init", new Class[]{class$java$security$KeyStore == null ? (class$java$security$KeyStore = SSLSocketClientFactory.class$("java.security.KeyStore")) : class$java$security$KeyStore}, new Object[]{keyStore});
            }
            catch (KeyStoreException keyStoreException) {
                throw keyStoreException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public void init(Object object) throws InvalidAlgorithmParameterException {
            try {
                this.invoke("init", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = SSLSocketClientFactory.class$("java.lang.Object")) : class$java$lang$Object}, new Object[]{object});
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw invalidAlgorithmParameterException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public Object getTrustManagers() {
            try {
                return this.invoke("getTrustManagers", null, null);
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }
    }

    private static final class KeyManagerFactory
    extends Delegator {
        private KeyManagerFactory(Object object) {
            super(object);
        }

        public String getDefaultAlgorithm() {
            try {
                return (String)this.invoke("getDefaultAlgorithm", null, null);
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public Object getInstance(String string) throws NoSuchAlgorithmException {
            try {
                return this.invoke("getInstance", new Class[]{class$java$lang$String == null ? (class$java$lang$String = SSLSocketClientFactory.class$("java.lang.String")) : class$java$lang$String}, new Object[]{string});
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public void init(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            try {
                this.invoke("init", new Class[]{class$java$security$KeyStore == null ? (class$java$security$KeyStore = SSLSocketClientFactory.class$("java.security.KeyStore")) : class$java$security$KeyStore, array$C == null ? (array$C = SSLSocketClientFactory.class$("[C")) : array$C}, new Object[]{keyStore, cArray});
            }
            catch (KeyStoreException keyStoreException) {
                throw keyStoreException;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw unrecoverableKeyException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public void init(Object object) throws InvalidAlgorithmParameterException {
            try {
                this.invoke("init", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = SSLSocketClientFactory.class$("java.lang.Object")) : class$java$lang$Object}, new Object[]{object});
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw invalidAlgorithmParameterException;
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }

        public Object getKeyManagers() {
            try {
                return this.invoke("getKeyManagers", null, null);
            }
            catch (Exception exception) {
                RuntimeException runtimeException = new RuntimeException(exception.toString());
                SSLAdapter.fillInStackTrace(runtimeException, exception);
                throw runtimeException;
            }
        }
    }
}

