/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http.mux;

import java.io.IOException;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.http.mux.MuxClient;
import org.w3c.util.ThreadCache;
import org.w3c.www.mux.MuxProtocolHandler;
import org.w3c.www.mux.MuxSession;

public class MuxHttpHandler
implements MuxProtocolHandler {
    protected httpd server = null;
    protected int cid = -1;
    protected int clientcount = 0;
    protected int maxclient = 50;
    protected ThreadCache threadcache = null;
    protected MuxClient freelist = null;

    private final synchronized MuxClient createClient() {
        ++this.clientcount;
        return new MuxClient(this.server, this, ++this.cid);
    }

    protected synchronized void markIdle(MuxClient muxClient) {
        muxClient.next = this.freelist;
        this.freelist = muxClient;
        this.notifyAll();
    }

    protected synchronized MuxClient getClient() {
        MuxClient muxClient = null;
        while (true) {
            if (this.freelist != null) {
                muxClient = this.freelist;
                this.freelist = muxClient.next;
                break;
            }
            if (this.clientcount + 1 < this.maxclient) {
                muxClient = this.createClient();
                break;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return muxClient;
    }

    public void initialize(MuxSession muxSession) throws IOException {
        MuxClient muxClient = this.getClient();
        muxClient.bind(muxSession);
        this.threadcache.getThread(muxClient, true);
    }

    public MuxHttpHandler(httpd httpd2) {
        this.server = httpd2;
        this.threadcache = new ThreadCache("mux-clients");
        this.threadcache.setCachesize(10);
        this.threadcache.setThreadPriority(httpd2.getClientThreadPriority());
        this.threadcache.initialize();
    }
}

